/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.Parameter;
import noesis.analysis.NodeScoreTask;

@Label(value="diffusion")
@Description(value="Diffusion centrality")
public class DiffusionCentrality
extends NodeScoreTask {
    public static final double DEFAULT_PASSING_PROBABILITY = 0.1;
    public static final int DEFAULT_PATH_LENGTH = 3;
    @Label(value="passing probability")
    @Parameter(min=0.0, max=1.0, defaultValue=0.1)
    private double passingProbability;
    @Label(value="path length")
    @Parameter(min=1.0, max=2.147483647E9, defaultValue=3.0)
    private int pathLength;

    public DiffusionCentrality(Network network) {
        this(network, 0.1, 3);
    }

    public DiffusionCentrality(Network network, double passingProbability, int iterations) {
        super(network);
        this.passingProbability = passingProbability;
        this.pathLength = iterations;
    }

    @Override
    public String getName() {
        return "diffusion(" + this.passingProbability + "," + this.pathLength + ")";
    }

    @Override
    public double compute(int node) {
        double value = 0.0;
        double poweredPassingProbability = this.passingProbability;
        int t = 1;
        while (t <= this.pathLength) {
            value += poweredPassingProbability * (double)this.computePathCount(node, 1, t);
            poweredPassingProbability *= this.passingProbability;
            ++t;
        }
        return value;
    }

    private int computePathCount(int currentNode, int currentDepth, int maxDepth) {
        Network network = this.getNetwork();
        if (currentDepth < maxDepth) {
            int value = 0;
            int i = 0;
            while (i < network.outDegree(currentNode)) {
                value += this.computePathCount(network.outLink(currentNode, i), currentDepth + 1, maxDepth);
                ++i;
            }
            return value;
        }
        if (currentDepth == maxDepth) {
            return network.outDegree(currentNode);
        }
        return 0;
    }
}

