/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.NodeScore;
import noesis.analysis.NodeScoreTask;

@Label(value="eigenvector")
@Description(value="Eigenvector centrality")
public class EigenvectorCentrality
extends NodeScoreTask {
    public static int MAX_ITERATIONS = 100;
    public static double EPSILON = 1.0E-6;

    public EigenvectorCentrality(Network network) {
        super(network);
    }

    @Override
    public void compute() {
        Network net = this.getNetwork();
        int size = net.size();
        double[] centrality = new double[size];
        double[] old = new double[size];
        int i = 0;
        while (i < size) {
            centrality[i] = 1.0 / (double)size;
            old[i] = centrality[i];
            ++i;
        }
        double change = Double.MAX_VALUE;
        int iteration = 0;
        while (iteration < MAX_ITERATIONS && change > EPSILON) {
            double[] tmp = old;
            old = centrality;
            centrality = tmp;
            double sum2 = 0.0;
            int v = 0;
            while (v < size) {
                centrality[v] = 0.0;
                int i2 = 0;
                while (i2 < net.inDegree(v)) {
                    int n = v;
                    centrality[n] = centrality[n] + old[net.inLink(v, i2)];
                    ++i2;
                }
                sum2 += centrality[v] * centrality[v];
                ++v;
            }
            double norm = Math.sqrt(sum2);
            change = 0.0;
            v = 0;
            while (v < size) {
                int n = v;
                centrality[n] = centrality[n] / norm;
                if (Math.abs(centrality[v] - old[v]) > change) {
                    change = Math.abs(centrality[v] - old[v]);
                }
                ++v;
            }
            ++iteration;
        }
        this.setResult(centrality);
    }

    @Override
    public double compute(int node) {
        this.checkDone();
        return ((NodeScore)this.getResult()).get(node);
    }
}

