/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.NodeScore;
import noesis.analysis.structure.Betweenness;

@Label(value="f-betweenness")
@Description(value="Freeman's betweenness")
public class FreemanBetweenness
extends Betweenness {
    public FreemanBetweenness(Network network) {
        super(network);
    }

    @Override
    public void compute() {
        super.compute();
        NodeScore score = (NodeScore)this.getResult();
        int node = 0;
        while (node < this.getNetwork().size()) {
            score.set(node, this.freemanBetweenness(node));
            ++node;
        }
        this.setResult(score);
    }

    protected double standardBetweenness(int node) {
        int size = this.getNetwork().size();
        return this.getResult(node) / (double)(size * size);
    }

    protected double freemanBetweenness(int node) {
        int size = this.getNetwork().size();
        return this.getResult(node) / (double)(size * size - size + 1);
    }
}

