/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.model.data.DataModel;
import noesis.Network;
import noesis.analysis.NodeScore;
import noesis.analysis.NodeScoreGroupTask;

public class HITS
extends NodeScoreGroupTask {
    public static final int HUB = 0;
    public static final int AUTHORITY = 1;
    public static int MAX_ITERATIONS = 100;
    public static double EPSILON = 1.0E-6;
    private double alpha;
    private double beta;
    private static final String[] names = new String[]{"hub", "authority"};
    private static final String[] descriptions = new String[]{"Hub centrality", "Authority centrality"};
    private static final DataModel[] models = new DataModel[]{NodeScore.REAL_MODEL, NodeScore.REAL_MODEL};

    public HITS(Network network) {
        this(network, 1.0, 1.0);
    }

    public HITS(Network network, double alpha, double beta) {
        super(network);
        this.alpha = alpha;
        this.beta = beta;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    @Override
    public String[] getNames() {
        return names;
    }

    @Override
    public String[] getDescriptions() {
        return descriptions;
    }

    @Override
    public DataModel[] getModels() {
        return models;
    }

    @Override
    public void compute() {
        Network net = this.getNetwork();
        int size = net.size();
        this.measures = this.createMeasures(net);
        double[] hub = new double[size];
        double[] authority = new double[size];
        double[] oldHub = new double[size];
        double[] oldAuthority = new double[size];
        int i = 0;
        while (i < size) {
            hub[i] = 1.0 / Math.sqrt(size);
            oldHub[i] = hub[i];
            authority[i] = 1.0 / Math.sqrt(size);
            oldAuthority[i] = authority[i];
            ++i;
        }
        double change = Double.MAX_VALUE;
        int iteration = 0;
        while (iteration < MAX_ITERATIONS && change > EPSILON) {
            double[] tmp = oldHub;
            oldHub = hub;
            hub = tmp;
            tmp = oldHub;
            oldHub = hub;
            hub = tmp;
            double sumHub = 0.0;
            double sumAuthority = 0.0;
            int v = 0;
            while (v < size) {
                hub[v] = 0.0;
                authority[v] = 0.0;
                int i2 = 0;
                while (i2 < net.outDegree(v)) {
                    int n = v;
                    hub[n] = hub[n] + oldAuthority[net.outLink(v, i2)];
                    ++i2;
                }
                i2 = 0;
                while (i2 < net.inDegree(v)) {
                    int n = v;
                    authority[n] = authority[n] + oldHub[net.inLink(v, i2)];
                    ++i2;
                }
                int n = v;
                hub[n] = hub[n] * this.beta;
                int n2 = v;
                authority[n2] = authority[n2] * this.alpha;
                sumHub += hub[v];
                sumAuthority += authority[v];
                ++v;
            }
            double normHub = sumHub;
            double normAuthority = sumAuthority;
            change = 0.0;
            v = 0;
            while (v < size) {
                int n = v;
                hub[n] = hub[n] / normHub;
                int n3 = v;
                authority[n3] = authority[n3] / normAuthority;
                if (Math.abs(hub[v] - oldHub[v]) > change) {
                    change = Math.abs(hub[v] - oldHub[v]);
                }
                if (Math.abs(authority[v] - oldAuthority[v]) > change) {
                    change = Math.abs(authority[v] - oldAuthority[v]);
                }
                ++v;
            }
            ++iteration;
        }
        ((NodeScore)this.measures.get(0)).set(hub);
        ((NodeScore)this.measures.get(1)).set(authority);
    }

    @Override
    public double[] compute(int node) {
        this.checkDone();
        return new double[]{((NodeScore)this.measures.get(0)).get(node), ((NodeScore)this.measures.get(1)).get(node)};
    }
}

