/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.model.data.annotations.Description;
import noesis.Network;
import noesis.Parameter;
import noesis.analysis.NodeScoreTask;

@Description(value="Katz centrality")
public class KatzCentrality
extends NodeScoreTask {
    public static final double DEFAULT_ALPHA = 1.0;
    public static final double DEFAULT_BETA = 1.0;
    public static int MAX_ITERATIONS = 100;
    public static double EPSILON = 1.0E-6;
    @Parameter(defaultValue=1.0)
    private double alpha;
    @Parameter(defaultValue=1.0)
    private double beta;

    public KatzCentrality(Network network) {
        this(network, 1.0, 1.0);
    }

    public KatzCentrality(Network network, double alpha) {
        this(network, alpha, 1.0);
    }

    public KatzCentrality(Network network, double alpha, double beta) {
        super(network);
        this.alpha = alpha;
        this.beta = beta;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    @Override
    public String getName() {
        return "katz(" + this.alpha + "," + this.beta + ")";
    }

    @Override
    public void compute() {
        Network net = this.getNetwork();
        int size = net.size();
        double[] centrality = new double[size];
        double[] old = new double[size];
        int i = 0;
        while (i < size) {
            centrality[i] = 1.0 / (double)size;
            old[i] = centrality[i];
            ++i;
        }
        double change = Double.MAX_VALUE;
        int iteration = 0;
        while (iteration < MAX_ITERATIONS && change > EPSILON) {
            double[] tmp = old;
            old = centrality;
            centrality = tmp;
            double sum2 = 0.0;
            int v = 0;
            while (v < size) {
                centrality[v] = 0.0;
                int i2 = 0;
                while (i2 < net.inDegree(v)) {
                    int n = v;
                    centrality[n] = centrality[n] + old[net.inLink(v, i2)];
                    ++i2;
                }
                centrality[v] = this.alpha * centrality[v] + this.beta / (double)size;
                sum2 += centrality[v] * centrality[v];
                ++v;
            }
            double norm = Math.sqrt(sum2);
            change = 0.0;
            v = 0;
            while (v < size) {
                int n = v;
                centrality[n] = centrality[n] / norm;
                if (Math.abs(centrality[v] - old[v]) > change) {
                    change = Math.abs(centrality[v] - old[v]);
                }
                ++v;
            }
            ++iteration;
        }
        this.setResult(centrality);
    }

    @Override
    public double compute(int node) {
        this.checkDone();
        return this.getResult(node);
    }
}

