/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.math.Vector;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import ikor.parallel.Kernel;
import ikor.parallel.Parallel;
import ikor.parallel.combiner.VectorAccumulator;
import noesis.Network;
import noesis.analysis.LinkScore;
import noesis.analysis.LinkScoreTask;
import noesis.analysis.structure.LinkBetweennessScore;
import noesis.network.LinkIndexer;

@Label(value="link-betweenness")
@Description(value="Link betweenness")
public class LinkBetweenness
extends LinkScoreTask {
    public LinkBetweenness(Network network) {
        super(network);
    }

    public LinkBetweenness(Network network, LinkIndexer index) {
        super(network, index);
    }

    @Override
    public double compute(int source, int destination) {
        this.checkDone();
        return ((LinkScore)this.getResult()).get(source, destination);
    }

    @Override
    public void compute() {
        Network net = this.getNetwork();
        LinkIndexer index = this.getLinkIndex();
        int size = net.size();
        int links = net.links();
        LinkScore result = new LinkScore(this, net, index);
        Vector score = (Vector)Parallel.reduce(new LinkBetweennessKernel(), new VectorAccumulator(links), 0, size - 1);
        int i = 0;
        while (i < score.size()) {
            result.set(i, score.get(i));
            ++i;
        }
        this.setResult(result);
    }

    private class LinkBetweennessKernel
    implements Kernel<Vector> {
        private LinkBetweennessKernel() {
        }

        @Override
        public Vector call(int index) {
            LinkBetweennessScore score = new LinkBetweennessScore(LinkBetweenness.this.getNetwork(), LinkBetweenness.this.getLinkIndex(), index);
            return (Vector)score.call();
        }
    }
}

