/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.LinkScore;
import noesis.analysis.LinkScoreTask;
import noesis.analysis.structure.BetweennessScore;
import noesis.network.LinkIndexer;

@Label(value="link-betweenness-score")
@Description(value="Link betweenness score")
public class LinkBetweennessScore
extends LinkScoreTask {
    private BetweennessScore score;
    private int node;

    public LinkBetweennessScore(Network network, LinkIndexer linkIndexer, int node) {
        super(network, linkIndexer);
        this.node = node;
        this.score = new BetweennessScore(network, node);
    }

    public int node() {
        return this.node;
    }

    public int distance(int node) {
        return this.score.distance(node);
    }

    public int geodesics(int node) {
        return this.score.geodesics(node);
    }

    public int visit(int pos) {
        return this.score.visit(pos);
    }

    public int visited() {
        return this.score.visited();
    }

    public double betweenness(int node) {
        return this.score.betweenness(node);
    }

    @Override
    public double compute(int source, int destination) {
        this.checkDone();
        return ((LinkScore)this.getResult()).get(source, destination);
    }

    @Override
    public void compute() {
        Network net = this.getNetwork();
        this.score.compute();
        LinkScore result = new LinkScore(this, net, this.getLinkIndex());
        int i = this.visited() - 1;
        while (i >= 0) {
            int currentNode = this.visit(i);
            int currentDistance = this.distance(currentNode);
            double currentGeodesics = this.geodesics(currentNode);
            double currentScore = this.betweenness(currentNode);
            int indegree = net.inDegree(currentNode);
            int[] inlinks = net.inLinks(currentNode);
            int j = 0;
            while (j < indegree) {
                if (this.distance(inlinks[j]) == currentDistance - 1) {
                    result.set(inlinks[j], currentNode, result.get(inlinks[j], currentNode) + (double)this.geodesics(inlinks[j]) * currentScore / currentGeodesics);
                }
                ++j;
            }
            --i;
        }
        this.setResult(result);
    }
}

