/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.collection.CollectionFactory;
import ikor.collection.Set;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.LinkScoreTask;

@Label(value="embeddedness")
@Description(value="Link embeddedness, a.k.a. shared neighbors")
public class LinkEmbeddedness
extends LinkScoreTask {
    public LinkEmbeddedness(Network network) {
        super(network);
    }

    protected Set<Integer> neighborhood(int node) {
        Network net = this.getNetwork();
        Set neighbors = CollectionFactory.createSet();
        int i = 0;
        while (i < net.inDegree(node)) {
            neighbors.add(net.inLink(node, i));
            ++i;
        }
        i = 0;
        while (i < net.outDegree(node)) {
            neighbors.add(net.outLink(node, i));
            ++i;
        }
        return neighbors;
    }

    @Override
    public double compute(int source, int destination) {
        Set<Integer> sourceNeighborhood = this.neighborhood(source);
        Set<Integer> destinationNeighborhood = this.neighborhood(destination);
        Set<Integer> sharedNeighborhood = sourceNeighborhood.intersection(destinationNeighborhood);
        return sharedNeighborhood.size();
    }
}

