/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.collection.Set;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.structure.LinkEmbeddedness;

@Label(value="neighborhood-overlap")
@Description(value="Link neighborhood overlap")
public class LinkNeighborhoodOverlap
extends LinkEmbeddedness {
    public LinkNeighborhoodOverlap(Network network) {
        super(network);
    }

    @Override
    public double compute(int source, int destination) {
        Set<Integer> sourceNeighborhood = this.neighborhood(source);
        Set<Integer> destinationNeighborhood = this.neighborhood(destination);
        Set<Integer> sharedNeighborhood = sourceNeighborhood.intersection(destinationNeighborhood);
        Set<Integer> linkNeighborhood = sourceNeighborhood.union(destinationNeighborhood);
        linkNeighborhood.remove(source);
        linkNeighborhood.remove(destination);
        return (double)sharedNeighborhood.size() / (double)linkNeighborhood.size();
    }
}

