/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.algorithms.traversal.StronglyConnectedComponents;
import noesis.analysis.NodeScore;
import noesis.analysis.structure.Betweenness;

@Label(value="norm-betweenness")
@Description(value="Normalized betweenness")
public class NormalizedBetweenness
extends Betweenness {
    public NormalizedBetweenness(Network network) {
        super(network);
    }

    @Override
    public void compute() {
        super.compute();
        NodeScore score = (NodeScore)this.getResult();
        StronglyConnectedComponents scc = new StronglyConnectedComponents(this.getNetwork());
        scc.compute();
        int node = 0;
        while (node < this.getNetwork().size()) {
            int size = scc.componentSize(node);
            score.set(node, (score.get(node) - (double)(2 * size - 1)) / (double)(size * size - size + 1));
            ++node;
        }
        this.setResult(score);
    }
}

