/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.model.data.annotations.Description;
import noesis.Network;
import noesis.analysis.structure.Decay;

@Description(value="Normalized decay")
public class NormalizedDecay
extends Decay {
    public NormalizedDecay(Network network) {
        super(network);
    }

    public NormalizedDecay(Network network, double delta) {
        super(network, delta);
    }

    @Override
    public String getName() {
        return String.valueOf(super.getName()) + "-norm";
    }

    @Override
    public double compute(int node) {
        int size = this.getNetwork().size();
        if (size > 1 && this.getDelta() > 0.0) {
            return super.compute(node) / (this.getDelta() * (double)(size - 1));
        }
        return 0.0;
    }
}

