/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.NodeScoreTask;

@Label(value="page-rank")
@Description(value="PageRank")
public class PageRank
extends NodeScoreTask {
    public static double DEFAULT_THETA = 0.85;
    public static double EPSILON = 1.0E-4;
    private double theta = DEFAULT_THETA;
    double[] pagerank;
    double[] weight;

    public PageRank(Network network) {
        this(network, DEFAULT_THETA);
    }

    public PageRank(Network network, double theta) {
        super(network);
        this.theta = theta;
    }

    @Override
    public void compute() {
        boolean changes;
        Network net = this.getNetwork();
        int size = net.size();
        this.pagerank = new double[size];
        int i = 0;
        while (i < size) {
            this.pagerank[i] = 1.0 / (double)size;
            ++i;
        }
        this.weight = new double[size];
        boolean[] dangling = new boolean[size];
        i = 0;
        while (i < size) {
            if (net.outDegree(i) > 0) {
                this.weight[i] = 1.0 / (double)net.outDegree(i);
            } else {
                dangling[i] = true;
            }
            ++i;
        }
        do {
            changes = false;
            double[] rank = new double[size];
            double danglingRank = 0.0;
            i = 0;
            while (i < size) {
                if (dangling[i]) {
                    danglingRank += this.pagerank[i];
                }
                ++i;
            }
            danglingRank /= (double)size;
            double randomRank = 1.0 / (double)size;
            int node = 0;
            while (node < size) {
                double old = this.pagerank[node];
                rank[node] = this.pagerank(net, node, danglingRank, randomRank);
                if (!changes && Math.abs(rank[node] - old) > EPSILON) {
                    changes = true;
                }
                ++node;
            }
            this.updateRank(rank);
        } while (changes);
        this.weight = null;
        dangling = null;
        this.setResult(this.pagerank);
    }

    private void updateRank(double[] rank) {
        this.pagerank = rank;
    }

    private double pagerank(Network net, int node, double danglingRank, double randomRank) {
        int degree = net.inDegree(node);
        int[] links = net.inLinks(node);
        double rank = 0.0;
        rank = 0.0;
        if (links != null) {
            int i = 0;
            while (i < degree) {
                rank += this.pagerank[links[i]] * this.weight[links[i]];
                ++i;
            }
        }
        return this.theta * (rank + danglingRank) + (1.0 - this.theta) * randomRank;
    }

    @Override
    public double compute(int node) {
        this.checkDone();
        return this.getResult(node);
    }
}

