/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.algorithms.LinkVisitor;
import noesis.algorithms.traversal.NetworkBFS;
import noesis.algorithms.traversal.NetworkTraversal;
import noesis.analysis.NodeScore;
import noesis.analysis.NodeScoreTask;

@Label(value="path-length")
@Description(value="Path length")
public class PathLength
extends NodeScoreTask {
    private int node;
    private NodeScore score;

    public PathLength(Network network, int node) {
        super(network);
        this.node = node;
    }

    public int node() {
        return this.node;
    }

    @Override
    public void compute() {
        Network network = this.getNetwork();
        this.score = new NodeScore(this, network);
        NetworkBFS bfs = new NetworkBFS(network);
        bfs.setLinkVisitor(new BFSVisitor(this));
        ((NetworkTraversal)bfs).traverse(this.node);
        this.setResult(this.score);
    }

    @Override
    public double compute(int node) {
        this.checkDone();
        return this.getResult(node);
    }

    public double averagePathLength() {
        this.checkDone();
        int reachable = this.reachableNodes();
        if (reachable > 0) {
            return ((NodeScore)this.getResult()).sum() / (double)reachable;
        }
        return 0.0;
    }

    public double closeness() {
        this.checkDone();
        int reachable = this.reachableNodes();
        double sumPathLengths = ((NodeScore)this.getResult()).sum();
        if (sumPathLengths > 0.0) {
            return (double)reachable / sumPathLengths;
        }
        return 0.0;
    }

    public double reachable() {
        this.checkDone();
        return (double)this.reachableNodes() / (double)(((NodeScore)this.getResult()).size() - 1);
    }

    public double decay(double delta) {
        this.checkDone();
        int nodes = this.getNetwork().size();
        double sum = 0.0;
        int i = 0;
        while (i < nodes) {
            if (this.getResult(i) > 0.0) {
                sum += Math.pow(delta, this.getResult(i));
            }
            ++i;
        }
        return sum;
    }

    public int reachableNodes() {
        int nodes = this.getNetwork().size();
        int total = 0;
        int i = 0;
        while (i < nodes) {
            if (this.getResult(i) > 0.0) {
                ++total;
            }
            ++i;
        }
        return total;
    }

    private class BFSVisitor
    extends LinkVisitor {
        private PathLength metrics;

        public BFSVisitor(PathLength metrics) {
            this.metrics = metrics;
        }

        @Override
        public void visit(int source, int destination) {
            if (destination != this.metrics.node() && this.metrics.score.get(destination) == 0.0) {
                this.metrics.score.set(destination, this.metrics.score.get(source) + 1.0);
            }
        }
    }
}

