/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure.communities;

import ikor.collection.CollectionFactory;
import ikor.collection.Dictionary;
import ikor.collection.List;
import ikor.math.DenseVector;
import ikor.math.Vector;
import ikor.model.data.DataModel;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.NodeScore;
import noesis.analysis.NodeScoreTask;

@Label(value="ClusterScoreTask")
@Description(value="Cluster score task")
public abstract class ClusterScoreTask
extends NodeScoreTask {
    private NodeScore assignment;
    private Dictionary<Integer, List<Integer>> clusters;

    public ClusterScoreTask(Network network, NodeScore assignment) {
        this(NodeScore.REAL_MODEL, network, assignment);
    }

    public ClusterScoreTask(DataModel model, Network network, NodeScore assignment) {
        super(model, network);
        this.assignment = assignment;
        this.clusters = CollectionFactory.createDictionary();
        int i = 0;
        while (i < assignment.size()) {
            int c = (int)assignment.get(i);
            if (!this.clusters.contains(c)) {
                this.clusters.set(c, CollectionFactory.createList());
            }
            ((List)this.clusters.get(c)).add(i);
            ++i;
        }
    }

    public int clusters() {
        return this.clusters.size();
    }

    public final Dictionary<Integer, List<Integer>> getClusters() {
        return this.clusters;
    }

    public NodeScore getAssignment() {
        return this.assignment;
    }

    public double nodeValue(int node) {
        return this.getResult(node);
    }

    public abstract double clusterValue(int var1);

    public final Vector clusterValues(int cluster) {
        List nodes = (List)this.clusters.get(cluster);
        DenseVector vector = new DenseVector(nodes.size());
        int i = 0;
        while (i < nodes.size()) {
            ((Vector)vector).set(i, this.nodeValue((Integer)nodes.get(i)));
            ++i;
        }
        return vector;
    }

    public abstract double overallValue();
}

