/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure.communities;

import ikor.collection.List;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.NodeScore;
import noesis.analysis.structure.communities.ClusterScoreTask;

@Label(value="Coverage Coefficient")
@Description(value="Coverage Coefficient")
public class CoverageCoefficient
extends ClusterScoreTask {
    public CoverageCoefficient(Network network, NodeScore clusters) {
        super(network, clusters);
    }

    @Override
    public double compute(int node) {
        Network net = this.getNetwork();
        int cluster = (int)this.getAssignment().get(node);
        List nodes = (List)this.getClusters().get(cluster);
        double m = net.links() / 2;
        double links = 0.0;
        int size = nodes.size();
        int i = 0;
        while (i < size) {
            int j = i + 1;
            while (j < size) {
                if (net.contains((Integer)nodes.get(i), (Integer)nodes.get(j))) {
                    links += 1.0;
                }
                ++j;
            }
            ++i;
        }
        return links / m / (double)size;
    }

    @Override
    public double overallValue() {
        return ((NodeScore)this.getResult()).sum();
    }

    @Override
    public double clusterValue(int cluster) {
        if (this.getClusters().contains(cluster)) {
            this.checkDone();
            return this.clusterValues(cluster).sum();
        }
        return Double.NaN;
    }
}

