/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure.communities;

import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.LinkScoreTask;

@Label(value="Link Clustering coefficient")
@Description(value="Link Clustering coefficient")
public class LinkClusteringCoefficient
extends LinkScoreTask {
    public LinkClusteringCoefficient(Network network) {
        super(network);
    }

    @Override
    public double compute(int source, int destination) {
        Network net = this.getNetwork();
        if (net.get(source, destination) == null) {
            return 0.0;
        }
        int triangles = 0;
        int[] links = net.outLinks(destination);
        if (links != null) {
            int i = 0;
            while (i < net.outDegree(destination)) {
                if (net.get(links[i], source) != null && source != links[i]) {
                    ++triangles;
                }
                ++i;
            }
        }
        int kj = net.outDegree(destination);
        int ki = net.inDegree(source);
        int denom = Math.max(ki, kj);
        if (denom == ki) {
            --denom;
        } else if (net.get(destination, source) != null) {
            --denom;
        }
        double result = 0.0;
        if (denom != 0) {
            result = (double)(triangles + 1) / (double)denom;
        }
        return result;
    }
}

