/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure.communities;

import ikor.collection.List;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.NodeScore;
import noesis.analysis.structure.communities.ClusterScoreTask;

@Label(value="Modularity")
@Description(value="Modularity")
public class ModularityCoefficient
extends ClusterScoreTask {
    public ModularityCoefficient(Network network, NodeScore clusters) {
        super(network, clusters);
    }

    @Override
    public double compute(int node) {
        double sum = 0.0;
        Network net = this.getNetwork();
        int m = net.links();
        int degree = net.degree(node);
        int cluster = (int)this.getAssignment().get(node);
        List nodes = (List)this.getClusters().get(cluster);
        int i = 0;
        while (i < nodes.size()) {
            double v = 0.0;
            int node2 = (Integer)nodes.get(i);
            if (net.get(node, node2) != null) {
                v = 1.0;
            }
            double kk = (double)(degree * net.degree(node2)) / (double)m;
            sum += v - kk;
            ++i;
        }
        return sum / (double)m;
    }

    @Override
    public double overallValue() {
        return ((NodeScore)this.getResult()).sum();
    }

    @Override
    public double clusterValue(int cluster) {
        if (this.getClusters().contains(cluster)) {
            this.checkDone();
            return this.clusterValues(cluster).sum();
        }
        return Double.NaN;
    }
}

