/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure.communities;

import ikor.collection.CollectionFactory;
import ikor.collection.List;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import java.util.Iterator;
import noesis.Network;
import noesis.analysis.NodeScore;
import noesis.analysis.structure.PathLength;
import noesis.analysis.structure.communities.ClusterScoreTask;

@Label(value="Separation")
@Description(value="Separation")
public class SeparationCoefficient
extends ClusterScoreTask {
    private List<NodeScore> paths = CollectionFactory.createList();

    public SeparationCoefficient(Network network, NodeScore clusters) {
        super(network, clusters);
        int node = 0;
        while (node < network.nodes()) {
            PathLength task = new PathLength(network, node);
            this.paths.add((NodeScore)task.call());
            ++node;
        }
    }

    @Override
    public double compute(int node) {
        int cluster = (int)this.getAssignment().get(node);
        double sum = 0.0;
        Iterator it = this.getClusters().iterator();
        while (it.hasNext()) {
            int c = (Integer)it.next();
            if (c == cluster) continue;
            List no = (List)this.getClusters().get(c);
            int i = 0;
            while (i < no.size()) {
                sum += ((NodeScore)this.paths.get(node)).get((Integer)no.get(i));
                ++i;
            }
        }
        return sum;
    }

    @Override
    public double overallValue() {
        return ((NodeScore)this.getResult()).average();
    }

    @Override
    public double clusterValue(int cluster) {
        if (this.getClusters().contains(cluster)) {
            this.checkDone();
            return this.clusterValues(cluster).average();
        }
        return Double.NaN;
    }
}

