/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure.communities;

import ikor.collection.CollectionFactory;
import ikor.collection.List;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import java.util.Iterator;
import noesis.Network;
import noesis.analysis.NodeScore;
import noesis.analysis.structure.PathLength;
import noesis.analysis.structure.communities.ClusterScoreTask;

@Label(value="Silhouette")
@Description(value="Silhouette coefficient")
public class SilhouetteCoefficient
extends ClusterScoreTask {
    private List<NodeScore> paths = CollectionFactory.createList();

    public SilhouetteCoefficient(Network network, NodeScore clusters) {
        super(network, clusters);
        int node = 0;
        while (node < network.nodes()) {
            PathLength task = new PathLength(network, node);
            this.paths.add((NodeScore)task.call());
            ++node;
        }
    }

    @Override
    public double compute(int node) {
        int cluster = (int)this.getAssignment().get(node);
        double distin = Double.MAX_VALUE;
        double distout = Double.MAX_VALUE;
        Iterator it = this.getClusters().iterator();
        while (it.hasNext()) {
            int c = (Integer)it.next();
            double sum = 0.0;
            double reachables = 0.0;
            List no = (List)this.getClusters().get(c);
            int i = 0;
            while (i < no.size()) {
                double l = ((NodeScore)this.paths.get(node)).get((Integer)no.get(i));
                if (l > 0.0) {
                    reachables += 1.0;
                    sum += l;
                }
                ++i;
            }
            double d = sum = reachables > 0.0 ? sum / reachables : 0.0;
            if (c != cluster) {
                if (!(sum < distout)) continue;
                distout = sum;
                continue;
            }
            distin = sum;
        }
        distout = distout == Double.MAX_VALUE ? 0.0 : distout;
        return (distout - distin) / Math.max(distin, distout);
    }

    @Override
    public double overallValue() {
        return ((NodeScore)this.getResult()).average();
    }

    @Override
    public double clusterValue(int cluster) {
        if (this.getClusters().contains(cluster)) {
            this.checkDone();
            return this.clusterValues(cluster).average();
        }
        return Double.NaN;
    }
}

