/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure.links.prediction;

import ikor.collection.DynamicList;
import noesis.Network;

public class DirectNeighborhoodOperations {
    private Network<?, ?> network;

    public DirectNeighborhoodOperations(Network network) {
        this.network = network;
    }

    public int getIntersectionCount(int firstNode, int secondNode) {
        int commonCount = 0;
        int[] nArray = this.network.outLinks(firstNode);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int firstLink = nArray[n2];
            int[] nArray2 = this.network.outLinks(secondNode);
            int n3 = nArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                int secondLink = nArray2[n4];
                if (firstLink == secondLink) {
                    ++commonCount;
                }
                ++n4;
            }
            ++n2;
        }
        return commonCount;
    }

    public final int[] getIntersection(int firstNode, int secondNode) {
        DynamicList<Integer> commonNeighborsList = new DynamicList<Integer>();
        if (this.network.outDegree(firstNode) == 0 || this.network.outDegree(secondNode) == 0) {
            return new int[0];
        }
        int[] nArray = this.network.outLinks(firstNode);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int firstLink = nArray[n2];
            int[] nArray2 = this.network.outLinks(secondNode);
            int n3 = nArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                int secondLink = nArray2[n4];
                if (firstLink == secondLink) {
                    commonNeighborsList.add(firstLink);
                }
                ++n4;
            }
            ++n2;
        }
        int[] commonNeighbors = new int[commonNeighborsList.size()];
        int index = 0;
        while (index < commonNeighborsList.size()) {
            commonNeighbors[index] = (Integer)commonNeighborsList.get(index);
            ++index;
        }
        return commonNeighbors;
    }

    public final int[] getUnion(int firstNode, int secondNode) {
        DynamicList<Integer> allNeighborsList = new DynamicList<Integer>();
        int firstNodeDegree = this.network.outDegree(firstNode);
        int secondNodeDegree = this.network.outDegree(secondNode);
        int firstNodeLinkIndex = 0;
        while (firstNodeLinkIndex < firstNodeDegree) {
            allNeighborsList.add(this.network.outLink(firstNode, firstNodeLinkIndex));
            ++firstNodeLinkIndex;
        }
        int secondNodeLinkIndex = 0;
        while (secondNodeLinkIndex < secondNodeDegree) {
            if (!allNeighborsList.contains(this.network.outLink(secondNode, secondNodeLinkIndex))) {
                allNeighborsList.add(this.network.outLink(secondNode, secondNodeLinkIndex));
            }
            ++secondNodeLinkIndex;
        }
        int[] allNeighbors = new int[allNeighborsList.size()];
        int index = 0;
        while (index < allNeighborsList.size()) {
            allNeighbors[index] = (Integer)allNeighborsList.get(index);
            ++index;
        }
        return allNeighbors;
    }
}

