/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure.links.prediction;

import ikor.math.Matrix;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import ikor.parallel.Task;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import noesis.Network;
import noesis.Parameter;

public abstract class NodePairMeasureTask
extends Task<Matrix> {
    private Network<?, ?> network;
    protected Matrix measure = null;

    public NodePairMeasureTask(Network<?, ?> network) {
        this.network = network;
    }

    public final Network<?, ?> getNetwork() {
        return this.network;
    }

    @Override
    public Matrix call() {
        this.compute();
        return this.measure;
    }

    public void checkDone() {
        if (this.measure == null) {
            this.compute();
        }
    }

    public abstract void compute();

    public String getName() {
        Class<?> type = this.getClass();
        String parameterTokens = Arrays.stream(type.getDeclaredFields()).map(field -> {
            Parameter parameter = field.getAnnotation(Parameter.class);
            String value = null;
            if (parameter != null) {
                field.setAccessible(true);
                try {
                    value = String.valueOf(field.getName()) + "=" + field.get(this).toString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return value;
        }).filter(value -> Objects.nonNull(value)).collect(Collectors.joining(","));
        Label label = type.getAnnotation(Label.class);
        if (label != null) {
            if (parameterTokens.length() > 0) {
                return String.valueOf(label.value()) + "(" + parameterTokens + ")";
            }
            return label.value();
        }
        return null;
    }

    public String getDescription() {
        Class<?> type = this.getClass();
        Description description = type.getAnnotation(Description.class);
        if (description != null) {
            return description.value();
        }
        return null;
    }
}

