/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure.links.prediction.global;

import ikor.math.Matrix;
import ikor.math.SparseMatrix;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.structure.links.prediction.global.GlobalUndirectedNodePairsMeasureTask;
import noesis.analysis.structure.links.prediction.global.LaplacianMatrix;
import noesis.analysis.structure.links.prediction.global.MatrixPseudoinversion;

@Label(value="avg-comm-time-score")
@Description(value="Average commute time score")
public class AverageCommuteTimeScore
extends GlobalUndirectedNodePairsMeasureTask {
    public AverageCommuteTimeScore(Network<?, ?> network) {
        super(network);
    }

    @Override
    public Matrix computeMatrix() {
        Network<?, ?> net = this.getNetwork();
        int numNodes = net.nodes();
        LaplacianMatrix laplacianMatrix = new LaplacianMatrix(net);
        Matrix inverseLaplacian = new MatrixPseudoinversion(laplacianMatrix).call();
        SparseMatrix similarity = new SparseMatrix(numNodes, numNodes);
        int node1 = 0;
        while (node1 < numNodes) {
            int node2 = 0;
            while (node2 < numNodes) {
                double denominator = inverseLaplacian.get(node1, node1) + inverseLaplacian.get(node2, node2) - 2.0 * inverseLaplacian.get(node1, node2);
                if (denominator > 0.0) {
                    double score = 1.0 / denominator;
                    ((Matrix)similarity).set(node1, node2, score);
                }
                ++node2;
            }
            ++node1;
        }
        return similarity;
    }
}

