/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure.links.prediction.global;

import ikor.math.Matrix;
import ikor.math.SparseMatrix;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.structure.links.prediction.global.RandomWalkScore;
import noesis.network.AdjacencyMatrix;

@Label(value="flow-propagation-score")
@Description(value="Flow propagation score")
public class FlowPropagationScore
extends RandomWalkScore {
    private static final double DEFAULT_EPSILON = 0.001;
    private static final int DEFAULT_MAX_ITERATIONS = 150;

    public FlowPropagationScore(Network<?, ?> network) {
        this(network, 0.001, 150);
    }

    public FlowPropagationScore(Network<?, ?> network, Double epsilon) {
        this(network, epsilon, 150);
    }

    public FlowPropagationScore(Network<?, ?> network, Double epsilon, Integer maxIterations) {
        super(network, epsilon, maxIterations);
    }

    @Override
    protected Matrix buildTransitionMatrix(Network<?, ?> network) {
        int numNodes = network.nodes();
        AdjacencyMatrix adjacencyMatrix = new AdjacencyMatrix(network);
        SparseMatrix d = new SparseMatrix(numNodes, numNodes);
        int actualNodeIndex = 0;
        while (actualNodeIndex < numNodes) {
            double denominator = network.outDegree(actualNodeIndex) + 1;
            ((Matrix)adjacencyMatrix).set(actualNodeIndex, actualNodeIndex, 1.0);
            if (network.outDegree(actualNodeIndex) > 0) {
                ((Matrix)d).set(actualNodeIndex, actualNodeIndex, 1.0 / Math.sqrt(denominator));
            }
            ++actualNodeIndex;
        }
        Matrix transitionMatrix = d.multiply((Matrix)adjacencyMatrix).multiply((Matrix)d);
        return transitionMatrix;
    }
}

