/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure.links.prediction.global;

import ikor.math.EigenvectorDecomposition;
import ikor.math.Matrix;
import ikor.math.SparseMatrix;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.structure.links.prediction.global.GlobalUndirectedNodePairsMeasureTask;
import noesis.network.AdjacencyMatrix;

@Label(value="global-leicht-holm-new-score")
@Description(value="Global Leicht-Holme-Newman score")
public class GlobalLeichtHolmeNewmanScore
extends GlobalUndirectedNodePairsMeasureTask {
    private static final double DEFAULT_BETA = 0.1;
    private static final int DEFAULT_MAX_ITERATIONS = 100;
    private static final double DEFAULT_EPSILON = 0.001;
    private double epsilon;
    private double beta;
    private int maxIterations;

    public GlobalLeichtHolmeNewmanScore(Network<?, ?> network) {
        this(network, 0.1, 100, 0.001);
    }

    public GlobalLeichtHolmeNewmanScore(Network<?, ?> network, Double beta) {
        this(network, beta, 100, 0.001);
    }

    public GlobalLeichtHolmeNewmanScore(Network<?, ?> network, Double beta, Integer maxIterations) {
        this(network, beta, maxIterations, 0.001);
    }

    public GlobalLeichtHolmeNewmanScore(Network<?, ?> network, Double beta, Integer maxIterations, Double epsilon) {
        super(network);
        this.beta = beta;
        this.maxIterations = maxIterations;
        this.epsilon = epsilon;
    }

    @Override
    public Matrix computeMatrix() {
        double diff;
        Network<?, ?> net = this.getNetwork();
        int numNodes = net.nodes();
        AdjacencyMatrix adjacencyMatrix = new AdjacencyMatrix(net);
        EigenvectorDecomposition eigen = new EigenvectorDecomposition(adjacencyMatrix);
        double dominantEigenvalue = eigen.getRealEigenvalues().max();
        Matrix S = new SparseMatrix(numNodes, numNodes);
        int iter = 0;
        do {
            SparseMatrix oldS = S;
            S = adjacencyMatrix.multiply(this.beta / dominantEigenvalue).multiply(S);
            int i = 0;
            while (i < numNodes) {
                S.set(i, i, S.get(i, i) + 1.0);
                ++i;
            }
            diff = 0.0;
            i = 0;
            while (i < numNodes) {
                int j = 0;
                while (j < numNodes) {
                    diff += Math.pow(S.get(i, j) - ((Matrix)oldS).get(i, j), 2.0);
                    ++j;
                }
                ++i;
            }
        } while (diff > this.epsilon && ++iter < this.maxIterations);
        return S;
    }
}

