/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure.links.prediction.global;

import ikor.math.Matrix;
import ikor.math.SparseMatrix;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.Parameter;
import noesis.analysis.structure.links.prediction.global.GlobalUndirectedNodePairsMeasureTask;

@Label(value="katz-score")
@Description(value="Katz score")
public class KatzScore
extends GlobalUndirectedNodePairsMeasureTask {
    private static final double DEFAULT_BETA = 0.1;
    @Parameter(min=0.0, max=1.0, defaultValue=0.1)
    @Description(value="Beta value")
    private double beta;

    public KatzScore(Network<?, ?> network) {
        super(network);
        this.beta = 0.1;
    }

    public KatzScore(Network<?, ?> network, Double beta) {
        super(network);
        this.beta = beta;
    }

    @Override
    protected Matrix computeMatrix() {
        Network<?, ?> net = this.getNetwork();
        int numNodes = net.nodes();
        SparseMatrix matrix = new SparseMatrix(numNodes, numNodes);
        int i = 0;
        while (i < numNodes) {
            int j = 0;
            while (j < numNodes) {
                if (i == j) {
                    matrix.set(i, i, 1.0);
                } else if (net.contains(i, j)) {
                    matrix.set(i, j, -this.beta);
                }
                ++j;
            }
            ++i;
        }
        Matrix result = matrix.inverse();
        int i2 = 0;
        while (i2 < numNodes) {
            result.set(i2, i2, matrix.get(i2, i2) + 1.0);
            ++i2;
        }
        return result;
    }
}

