/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure.links.prediction.global;

import ikor.math.Matrix;
import ikor.math.SingularValueDecomposition;
import ikor.math.SparseMatrix;
import ikor.parallel.Task;

public class MatrixPseudoinversion
extends Task<Matrix> {
    private static final double DEFAULT_EPSILON = 0.001;
    private double epsilon;
    private Matrix matrix;

    public MatrixPseudoinversion(Matrix matrix) {
        this(matrix, 0.001);
    }

    public MatrixPseudoinversion(Matrix matrix, double epsilon) {
        this.matrix = matrix;
        this.epsilon = epsilon;
    }

    @Override
    public Matrix call() {
        int size = this.matrix.rows();
        SingularValueDecomposition svdDecomposition = new SingularValueDecomposition(this.matrix);
        Matrix Um = svdDecomposition.getU();
        Matrix Sm = svdDecomposition.getS();
        Matrix Vm = svdDecomposition.getV();
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size) {
                Um.set(i, j, Math.abs(Um.get(i, j)) < this.epsilon ? 0.0 : Um.get(i, j));
                Sm.set(i, j, Math.abs(Sm.get(i, j)) < this.epsilon ? 0.0 : Sm.get(i, j));
                Vm.set(i, j, Math.abs(Vm.get(i, j)) < this.epsilon ? 0.0 : Vm.get(i, j));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            double val = Sm.get(i, i);
            if (val != 0.0) {
                Sm.set(i, i, 1.0 / val);
            }
            ++i;
        }
        Matrix resultm = Vm.multiply(Sm.multiply(Um.transpose()));
        SparseMatrix result = new SparseMatrix(size, size);
        int i2 = 0;
        while (i2 < size) {
            int j = 0;
            while (j < size) {
                ((Matrix)result).set(i2, j, resultm.get(i2, j));
                ++j;
            }
            ++i2;
        }
        return result;
    }
}

