/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure.links.prediction.global;

import ikor.math.Matrix;
import ikor.math.SparseMatrix;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.structure.links.prediction.global.GlobalUndirectedNodePairsMeasureTask;
import noesis.analysis.structure.links.prediction.global.LaplacianMatrix;

@Label(value="rand-forest-kern-score")
@Description(value="Random forest kernel score")
public class RandomForestKernelScore
extends GlobalUndirectedNodePairsMeasureTask {
    public RandomForestKernelScore(Network<?, ?> network) {
        super(network);
    }

    @Override
    public Matrix computeMatrix() {
        Network<?, ?> net = this.getNetwork();
        int numNodes = net.nodes();
        LaplacianMatrix laplacianMatrix = new LaplacianMatrix(net);
        SparseMatrix matrix = new SparseMatrix(numNodes, numNodes);
        int node1 = 0;
        while (node1 < numNodes) {
            int node2 = 0;
            while (node2 < numNodes) {
                double value = laplacianMatrix.get(node1, node2);
                if (node1 == node2) {
                    value += 1.0;
                }
                ((Matrix)matrix).set(node1, node2, value);
                ++node2;
            }
            ++node1;
        }
        return matrix.inverse();
    }
}

