/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure.links.prediction.global;

import ikor.math.Matrix;
import ikor.math.SparseMatrix;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.structure.links.prediction.global.GlobalUndirectedNodePairsMeasureTask;
import noesis.network.AdjacencyMatrix;

@Label(value="random-walk-score")
@Description(value="Random walk score")
public class RandomWalkScore
extends GlobalUndirectedNodePairsMeasureTask {
    private static final double DEFAULT_EPSILON = 0.001;
    private static final int DEFAULT_MAX_ITERATIONS = 150;
    private double epsilon;
    private int maxIterations;

    public RandomWalkScore(Network<?, ?> network) {
        this(network, 0.001, 150);
    }

    public RandomWalkScore(Network<?, ?> network, Double epsilon) {
        this(network, epsilon, 150);
    }

    public RandomWalkScore(Network<?, ?> network, Double epsilon, Integer maxIterations) {
        super(network);
        this.epsilon = epsilon;
        this.maxIterations = maxIterations;
    }

    @Override
    public Matrix computeMatrix() {
        Network<?, ?> net = this.getNetwork();
        int numNodes = net.nodes();
        Matrix transitionMatrix = this.buildTransitionMatrix(net);
        SparseMatrix probabilityMatrix = new SparseMatrix(numNodes, numNodes);
        int node1 = 0;
        while (node1 < numNodes) {
            if (net.outDegree(node1) > 0) {
                Matrix probabilityVector = new SparseMatrix(numNodes, 1);
                SparseMatrix oldprobabilityVector = null;
                probabilityVector.set(node1, 0, 1.0);
                double diff = 0.0;
                int iter = 0;
                do {
                    ++iter;
                    oldprobabilityVector = probabilityVector;
                    probabilityVector = transitionMatrix.multiply(probabilityVector);
                    diff = 0.0;
                    int i = 0;
                    while (i < numNodes) {
                        diff += Math.pow(probabilityVector.get(i, 0) - ((Matrix)oldprobabilityVector).get(i, 0), 2.0);
                        ++i;
                    }
                } while (diff > this.epsilon && iter < this.maxIterations);
                int node2 = 0;
                while (node2 < numNodes) {
                    if (node1 != node2) {
                        ((Matrix)probabilityMatrix).set(node1, node2, ((Matrix)probabilityMatrix).get(node1, node2) + probabilityVector.get(node2, 0));
                        ((Matrix)probabilityMatrix).set(node2, node1, ((Matrix)probabilityMatrix).get(node2, node1) + probabilityVector.get(node2, 0));
                    }
                    ++node2;
                }
            }
            ++node1;
        }
        return probabilityMatrix;
    }

    protected Matrix buildTransitionMatrix(Network<?, ?> network) {
        int numNodes = network.nodes();
        AdjacencyMatrix adjacencyMatrix = new AdjacencyMatrix(network);
        SparseMatrix transitionMatrix = new SparseMatrix(numNodes, numNodes);
        int node1 = 0;
        while (node1 < numNodes) {
            double denominator = network.outDegree(node1) + 1;
            ((Matrix)transitionMatrix).set(node1, node1, 1.0 / denominator);
            int node2 = 0;
            while (node2 < numNodes) {
                if (((Matrix)adjacencyMatrix).get(node1, node2) == 1.0) {
                    ((Matrix)transitionMatrix).set(node1, node2, ((Matrix)adjacencyMatrix).get(node1, node2) / denominator);
                }
                ++node2;
            }
            ++node1;
        }
        return transitionMatrix;
    }
}

