/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure.links.prediction.global;

import ikor.math.Matrix;
import ikor.math.SparseMatrix;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.Parameter;
import noesis.analysis.structure.links.prediction.global.RandomWalkScore;

@Label(value="random-walk-restart-score")
@Description(value="Random walk with restart score")
public class RandomWalkWithRestartScore
extends RandomWalkScore {
    private static final double DEFAULT_ALPHA = 0.9;
    private static final double DEFAULT_EPSILON = 0.001;
    private static final int DEFAULT_MAX_ITERATIONS = 150;
    @Parameter(min=0.0, max=1.0, defaultValue=0.9)
    @Description(value="Alpha value")
    private double alpha;
    private double epsilon;
    private int maxIterations;

    public RandomWalkWithRestartScore(Network<?, ?> network) {
        this(network, 0.9);
    }

    public RandomWalkWithRestartScore(Network<?, ?> network, Double alpha) {
        this(network, alpha, 0.001);
    }

    public RandomWalkWithRestartScore(Network<?, ?> network, Double alpha, Double epsilon) {
        this(network, alpha, epsilon, 150);
    }

    public RandomWalkWithRestartScore(Network<?, ?> network, Double alpha, Double epsilon, Integer maxIterations) {
        super(network);
        this.alpha = alpha;
        this.epsilon = epsilon;
        this.maxIterations = maxIterations;
    }

    @Override
    public Matrix computeMatrix() {
        Network<?, ?> net = this.getNetwork();
        int numNodes = net.nodes();
        Matrix transitionMatrix = this.buildTransitionMatrix(net);
        SparseMatrix probabilityMatrix = new SparseMatrix(numNodes, numNodes);
        int node1 = 0;
        while (node1 < numNodes) {
            if (net.outDegree(node1) > 0) {
                Matrix probabilityVector = new SparseMatrix(numNodes, 1);
                SparseMatrix oldprobabilityVector = null;
                probabilityVector.set(node1, 0, 1.0);
                SparseMatrix seedVector = new SparseMatrix(numNodes, 1);
                ((Matrix)seedVector).set(node1, 0, 1.0);
                double diff = 0.0;
                int iter = 0;
                do {
                    ++iter;
                    oldprobabilityVector = probabilityVector;
                    probabilityVector = transitionMatrix.multiply(probabilityVector);
                    probabilityVector = transitionMatrix.multiply(probabilityVector).multiply(this.alpha).add(seedVector.multiply(1.0 - this.alpha));
                    diff = 0.0;
                    int i = 0;
                    while (i < numNodes) {
                        diff += Math.pow(probabilityVector.get(i, 0) - ((Matrix)oldprobabilityVector).get(i, 0), 2.0);
                        ++i;
                    }
                } while (diff > this.epsilon && iter < this.maxIterations);
                int node2 = 0;
                while (node2 < numNodes) {
                    if (node1 != node2) {
                        ((Matrix)probabilityMatrix).set(node1, node2, ((Matrix)probabilityMatrix).get(node1, node2) + probabilityVector.get(node2, 0));
                        ((Matrix)probabilityMatrix).set(node2, node1, ((Matrix)probabilityMatrix).get(node2, node1) + probabilityVector.get(node2, 0));
                    }
                    ++node2;
                }
            }
            ++node1;
        }
        return probabilityMatrix;
    }
}

