/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure.links.prediction.local;

import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.structure.links.prediction.DirectNeighborhoodOperations;
import noesis.analysis.structure.links.prediction.local.LocalUndirectedNodePairsMeasureTask;

@Label(value="adamic-adar-score")
@Description(value="Adamic-Adar score")
public class AdamicAdarScore
extends LocalUndirectedNodePairsMeasureTask {
    public AdamicAdarScore(Network<?, ?> network) {
        super(network);
    }

    @Override
    public double compute(int sourceNode, int destinationNode) {
        Network<?, ?> net = this.getNetwork();
        DirectNeighborhoodOperations neighborhoodOperations = new DirectNeighborhoodOperations(net);
        int[] commonNeighbors = neighborhoodOperations.getIntersection(sourceNode, destinationNode);
        double score = 0.0;
        int index = 0;
        while (index < commonNeighbors.length) {
            score += 1.0 / Math.log(net.outDegree(commonNeighbors[index]));
            ++index;
        }
        return score;
    }
}

