/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure.links.prediction.local;

import ikor.math.SparseMatrix;
import noesis.Network;
import noesis.analysis.structure.links.prediction.NodePairMeasureTask;

public abstract class LocalUndirectedNodePairsMeasureTask
extends NodePairMeasureTask {
    public LocalUndirectedNodePairsMeasureTask(Network<?, ?> network) {
        super(network);
    }

    @Override
    public void compute() {
        Network<?, ?> network = this.getNetwork();
        int numNodes = network.nodes();
        this.measure = new SparseMatrix(numNodes, numNodes);
        int sourceNodeIndex = 0;
        while (sourceNodeIndex < numNodes) {
            int[] sourceNeighbors = network.outLinks(sourceNodeIndex);
            if (sourceNeighbors != null) {
                int[] nArray = sourceNeighbors;
                int n = sourceNeighbors.length;
                int n2 = 0;
                while (n2 < n) {
                    int sourceNeighborIndex = nArray[n2];
                    int[] firstNeighbors = network.outLinks(sourceNeighborIndex);
                    if (firstNeighbors != null) {
                        int[] nArray2 = firstNeighbors;
                        int n3 = firstNeighbors.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int firstNeighborIndex = nArray2[n4];
                            if (firstNeighborIndex < sourceNodeIndex && this.measure.get(sourceNodeIndex, firstNeighborIndex) == 0.0) {
                                double computedScore = this.compute(sourceNodeIndex, firstNeighborIndex);
                                this.measure.set(sourceNodeIndex, firstNeighborIndex, computedScore);
                                this.measure.set(firstNeighborIndex, sourceNodeIndex, computedScore);
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            ++sourceNodeIndex;
        }
    }

    public abstract double compute(int var1, int var2);
}

