/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure.links.prediction.local;

import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.structure.links.prediction.DirectNeighborhoodOperations;
import noesis.analysis.structure.links.prediction.local.LocalUndirectedNodePairsMeasureTask;

@Label(value="res-alloc-score")
@Description(value="Resource allocation score")
public class ResourceAllocationScore
extends LocalUndirectedNodePairsMeasureTask {
    public ResourceAllocationScore(Network<?, ?> network) {
        super(network);
    }

    @Override
    public double compute(int sourceNode, int destinationNode) {
        Network<?, ?> net = this.getNetwork();
        DirectNeighborhoodOperations neighborhoodOperations = new DirectNeighborhoodOperations(net);
        int[] commonNeighbors = neighborhoodOperations.getIntersection(sourceNode, destinationNode);
        double score = 0.0;
        int index = 0;
        while (index < commonNeighbors.length) {
            score += 1.0 / (double)net.outDegree(commonNeighbors[index]);
            ++index;
        }
        return score;
    }
}

