/*
 * Decompiled with CFR 0.152.
 */
package noesis.io;

import ikor.math.Decimal;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;
import noesis.Network;
import noesis.io.NetworkReader;

public class ASCIINetworkReader
extends NetworkReader<String, Decimal> {
    private BufferedReader input;
    private boolean directed;

    public ASCIINetworkReader() {
        this.input = null;
        this.directed = false;
    }

    public ASCIINetworkReader(Reader reader) {
        this.setReader(reader);
    }

    public ASCIINetworkReader(Reader reader, boolean directed) {
        this.setReader(reader);
        this.directed = directed;
    }

    public void setReader(Reader reader) {
        this.input = new BufferedReader(reader);
    }

    private String readLine() throws IOException {
        String line;
        while ((line = this.input.readLine()) != null && line.trim().length() == 0) {
        }
        return line;
    }

    @Override
    public Network<String, Decimal> read() throws IOException {
        Network<String, Decimal> net = this.createNetwork();
        String line = this.readLine();
        StringTokenizer tokenizer = new StringTokenizer(line);
        int nodes = Integer.parseInt(tokenizer.nextToken());
        net.setSize(nodes);
        line = this.readLine();
        while (line != null) {
            tokenizer = new StringTokenizer(line);
            int source = Integer.parseInt(tokenizer.nextToken()) - 1;
            int destination = Integer.parseInt(tokenizer.nextToken()) - 1;
            Decimal value = new Decimal(tokenizer.nextToken());
            net.add((String)source, (String)destination, value);
            if (!this.directed) {
                net.add((String)destination, (String)source, value);
            }
            line = this.readLine();
        }
        return net;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

