/*
 * Decompiled with CFR 0.152.
 */
package noesis.io;

import ikor.collection.CollectionFactory;
import ikor.collection.List;
import ikor.model.data.DataModel;
import ikor.model.data.IntegerModel;
import ikor.model.data.RealModel;
import ikor.model.data.TextModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.LinkAttribute;
import noesis.Network;
import noesis.io.AttributeNetworkReader;

public class GDFNetworkReader
extends AttributeNetworkReader {
    private BufferedReader input;
    private String line;
    private Pattern pattern;
    private static final String REGEX = "(^|,) *(\"[^\"]*\"|'[^']*'|[^,]*) *";
    int nodeIDColumn = -1;
    int linkSourceColumn = -1;
    int linkTargetColumn = -1;
    String[] nodeAttributes;
    String[] linkAttributes;

    public GDFNetworkReader(Reader reader) {
        this.input = new BufferedReader(reader);
        this.line = null;
        this.pattern = Pattern.compile(REGEX);
        this.setType(AttributeNetwork.class);
    }

    private String readLine() throws IOException {
        do {
            this.line = this.input.readLine();
            if (this.line == null) continue;
            this.line = this.line.trim();
        } while (this.line != null && (this.line.length() == 0 || this.line.startsWith("#")));
        return this.line;
    }

    public List<String> parseString(String line) {
        List fields = CollectionFactory.createList();
        Matcher matcher = this.pattern.matcher(line);
        while (matcher.find()) {
            String field = matcher.group(2);
            if (field.length() > 0 && (field.charAt(0) == '\"' && field.charAt(field.length() - 1) == '\"' || field.charAt(0) == '\'' && field.charAt(field.length() - 1) == '\'')) {
                field = field.substring(1, field.length() - 1);
            }
            fields.add(field);
        }
        return fields;
    }

    private void processNodeDef(AttributeNetwork net, String s) {
        this.nodeAttributes = this.processDef(net, s, true);
    }

    private void processEdgeDef(AttributeNetwork net, String s) {
        this.linkAttributes = this.processDef(net, s, false);
    }

    private String[] processDef(AttributeNetwork net, String s, boolean node) {
        String[] items = s.split(",");
        int i = 0;
        while (i < items.length) {
            String name;
            String t = items[i].trim().toLowerCase();
            String[] elements = t.split(" ");
            items[i] = name = elements[0];
            if (node) {
                if (name.equalsIgnoreCase("name")) {
                    this.nodeIDColumn = i;
                } else if (elements.length == 1) {
                    net.addNodeAttribute(new Attribute(name));
                } else {
                    net.addNodeAttribute(new Attribute(name, this.dataModel(elements[1])));
                }
            } else if (name.equalsIgnoreCase("node1") || name.equalsIgnoreCase("n1")) {
                this.linkSourceColumn = i;
            } else if (name.equalsIgnoreCase("node2") || name.equalsIgnoreCase("n2")) {
                this.linkTargetColumn = i;
            } else if (elements.length == 1) {
                net.addLinkAttribute(new LinkAttribute(net, name));
            } else {
                net.addLinkAttribute(new LinkAttribute(net, name, this.dataModel(elements[1])));
            }
            ++i;
        }
        return items;
    }

    private DataModel dataModel(String dataType) {
        String type = dataType.toLowerCase();
        DataModel<Double> model = type.equals("double") || type.equals("float") ? new RealModel() : (type.equals("integer") || type.equals("tinyint") ? new IntegerModel() : new TextModel());
        return model;
    }

    private void processNode(AttributeNetwork net, String line) {
        List<String> vals = this.parseString(line);
        int node = net.size();
        net.add(node);
        this.setNodeID(net, node, (String)vals.get(this.nodeIDColumn));
        int i = 0;
        while (i < vals.size()) {
            if (i != this.nodeIDColumn) {
                this.setNodeAttribute(net, node, this.nodeAttributes[i], (String)vals.get(i));
            }
            ++i;
        }
    }

    private void processLink(AttributeNetwork net, String line) {
        List<String> vals = this.parseString(line);
        int source = this.getNodeIndex((String)vals.get(this.linkSourceColumn));
        int target = this.getNodeIndex((String)vals.get(this.linkTargetColumn));
        this.addLink(net, source, target);
        int i = 0;
        while (i < vals.size()) {
            if (i != this.linkSourceColumn && i != this.linkTargetColumn) {
                this.setLinkAttribute(net, source, target, this.linkAttributes[i], (String)vals.get(i));
            }
            ++i;
        }
    }

    public Network read() throws IOException {
        String line = null;
        boolean inNodeDef = false;
        boolean inEdgeDef = false;
        AttributeNetwork net = new AttributeNetwork();
        net.setID("");
        net.addNodeAttribute(new Attribute("id"));
        while ((line = this.readLine()) != null) {
            if (line.startsWith("nodedef>")) {
                inEdgeDef = false;
                inNodeDef = true;
                this.processNodeDef(net, line.substring(8));
                continue;
            }
            if (line.startsWith("edgedef>")) {
                inEdgeDef = true;
                inNodeDef = false;
                this.processEdgeDef(net, line.substring(8));
                continue;
            }
            if (inNodeDef) {
                this.processNode(net, line);
                continue;
            }
            if (!inEdgeDef) continue;
            this.processLink(net, line);
        }
        return net;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

