/*
 * Decompiled with CFR 0.152.
 */
package noesis.io;

import ikor.model.data.IntegerModel;
import ikor.model.data.RealModel;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.LinkAttribute;
import noesis.Network;
import noesis.io.AttributeNetworkWriter;

public class GDFNetworkWriter
extends AttributeNetworkWriter {
    private BufferedWriter writer;

    public GDFNetworkWriter(Writer writer) {
        this.writer = new BufferedWriter(writer);
    }

    @Override
    public void write(Network net) throws IOException {
        this.writeNodes(net);
        this.writeLinks(net);
        this.writer.flush();
    }

    public void writeNodes(Network net) throws IOException {
        this.writeNodeDef(net);
        int i = 0;
        while (i < net.size()) {
            this.writeNode(net, i);
            ++i;
        }
    }

    public void writeNodeDef(Network net) throws IOException {
        this.writer.write("nodedef>name");
        if (net instanceof AttributeNetwork) {
            AttributeNetwork attrnet = (AttributeNetwork)net;
            int attributes = attrnet.getNodeAttributeCount();
            int i = 0;
            while (i < attributes) {
                Attribute attribute = attrnet.getNodeAttribute(i);
                String id = attribute.getID();
                if (!id.equals("id")) {
                    this.writer.write("," + attribute.getID());
                }
                if (attribute.getModel() instanceof IntegerModel) {
                    this.writer.write(" INTEGER");
                } else if (attribute.getModel() instanceof RealModel) {
                    this.writer.write(" DOUBLE");
                }
                ++i;
            }
        }
        this.writer.newLine();
    }

    public void writeNode(Network net, int index) throws IOException {
        if (net instanceof AttributeNetwork) {
            AttributeNetwork attrnet = (AttributeNetwork)net;
            this.writer.write(attrnet.getNodeAttribute("id").get(index).toString());
            int attributes = attrnet.getNodeAttributeCount();
            int i = 0;
            while (i < attributes) {
                Attribute attribute = attrnet.getNodeAttribute(i);
                String id = attribute.getID();
                if (!id.equals("id")) {
                    this.writer.write("," + this.valueString(attribute.get(index)));
                }
                ++i;
            }
        } else {
            this.writer.write("" + index);
        }
        this.writer.newLine();
    }

    private String valueString(Object value) throws IOException {
        if (value != null) {
            String str = value.toString();
            if (str.contains("\"")) {
                return "'" + str + "'";
            }
            if (str.contains(",") || str.contains("'")) {
                return "\"" + str + "\"";
            }
            return str;
        }
        return "";
    }

    public void writeLinks(Network net) throws IOException {
        this.writeLinkDef(net);
        int i = 0;
        while (i < net.size()) {
            int[] outlinks = net.outLinks(i);
            if (outlinks != null) {
                int j = 0;
                while (j < outlinks.length) {
                    this.writeLink(net, i, outlinks[j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    public void writeLinkDef(Network net) throws IOException {
        this.writer.write("edgedef>node1,node2");
        if (net instanceof AttributeNetwork) {
            AttributeNetwork attrnet = (AttributeNetwork)net;
            int attributes = attrnet.getLinkAttributeCount();
            int i = 0;
            while (i < attributes) {
                LinkAttribute attribute = attrnet.getLinkAttribute(i);
                this.writer.write("," + attribute.getID());
                if (attribute.getModel() instanceof IntegerModel) {
                    this.writer.write(" INTEGER");
                } else if (attribute.getModel() instanceof RealModel) {
                    this.writer.write(" DOUBLE");
                }
                ++i;
            }
        }
        this.writer.newLine();
    }

    public void writeLink(Network net, int source, int target) throws IOException {
        if (net instanceof AttributeNetwork) {
            AttributeNetwork attrnet = (AttributeNetwork)net;
            Attribute nodeID = attrnet.getNodeAttribute("id");
            this.writer.write(nodeID.get(source).toString());
            this.writer.write(",");
            this.writer.write(nodeID.get(target).toString());
            int attributes = attrnet.getLinkAttributeCount();
            int i = 0;
            while (i < attributes) {
                LinkAttribute attribute = attrnet.getLinkAttribute(i);
                this.writer.write("," + this.valueString(attribute.get(source, target)));
                ++i;
            }
        } else {
            this.writer.write(String.valueOf(source) + "," + target);
        }
        this.writer.newLine();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

