/*
 * Decompiled with CFR 0.152.
 */
package noesis.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.Network;
import noesis.io.AttributeNetworkReader;

public class GMLNetworkReader
extends AttributeNetworkReader {
    private BufferedReader input;
    private String line;

    public GMLNetworkReader(Reader reader) {
        this.input = new BufferedReader(reader);
        this.line = null;
        this.setType(AttributeNetwork.class);
    }

    private String readLine() throws IOException {
        do {
            this.line = this.input.readLine();
            if (this.line == null) continue;
            this.line = this.line.replace('[', ' ').replace(']', ' ').trim();
        } while (this.line != null && this.line.length() == 0);
        return this.line;
    }

    private String currentLine() {
        return this.line;
    }

    public Network read() throws IOException {
        boolean inNode = false;
        boolean inEdge = false;
        int source = 0;
        int target = 0;
        AttributeNetwork net = new AttributeNetwork();
        net.addNodeAttribute(new Attribute("id"));
        int nodes = net.size();
        while (this.readLine() != null) {
            String line = this.currentLine();
            String[] items = line.split("\\s+");
            String key = line.toLowerCase();
            if (key.startsWith("node")) {
                net.add(++nodes - 1);
                inNode = true;
                inEdge = false;
                continue;
            }
            if (key.startsWith("edge")) {
                inNode = false;
                inEdge = true;
                continue;
            }
            if (inNode && key.startsWith("id")) {
                this.setNodeID(net, nodes - 1, this.parseAttribute(items[0], line));
                continue;
            }
            if (inEdge && key.startsWith("source")) {
                source = this.getNodeIndex(this.parseAttribute(items[0], line));
                continue;
            }
            if (inEdge && key.startsWith("target")) {
                target = this.getNodeIndex(this.parseAttribute(items[0], line));
                this.addLink(net, source, target);
                continue;
            }
            if (!Character.isAlphabetic(key.charAt(0))) continue;
            if (inNode) {
                this.setNodeAttribute(net, nodes - 1, items[0], this.parseAttribute(items[0], line));
                continue;
            }
            if (inEdge) {
                this.setLinkAttribute(net, source, target, items[0], this.parseAttribute(items[0], line));
                continue;
            }
            if (!key.startsWith("directed")) continue;
            int val = Integer.parseInt(items[1]);
            if (val != 0) {
                net.setDirected(true);
                continue;
            }
            net.setDirected(false);
        }
        return net;
    }

    private String parseAttribute(String id, String line) {
        Pattern pattern = Pattern.compile(String.valueOf(id) + "\\s+(([^\"]*)|\"([^\"]+)\")");
        Matcher m = pattern.matcher(line);
        if (m.matches()) {
            if (m.group(2) != null) {
                return m.group(2);
            }
            return m.group(3);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

