/*
 * Decompiled with CFR 0.152.
 */
package noesis.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.LinkAttribute;
import noesis.Network;
import noesis.io.AttributeNetworkWriter;

public class GMLNetworkWriter
extends AttributeNetworkWriter {
    private BufferedWriter writer;

    public GMLNetworkWriter(Writer writer) {
        this.writer = new BufferedWriter(writer);
    }

    @Override
    public void write(Network net) throws IOException {
        this.writer.write("graph");
        this.writer.newLine();
        this.writer.write("[");
        this.writer.newLine();
        if (net.isDirected()) {
            this.writer.write("\tdirected 1");
        } else {
            this.writer.write("\tdirected 0");
        }
        this.writer.newLine();
        this.writer.write("\tcreator \"NOESIS\"");
        this.writer.newLine();
        this.writeNodes(net);
        this.writeLinks(net);
        this.writer.write("]");
        this.writer.newLine();
        this.writer.flush();
    }

    public void writeNodes(Network net) throws IOException {
        int i = 0;
        while (i < net.size()) {
            this.writeNode(net, i);
            ++i;
        }
    }

    public void writeNode(Network net, int index) throws IOException {
        this.writer.write("\tnode [");
        this.writer.newLine();
        if (net instanceof AttributeNetwork) {
            AttributeNetwork attrnet = (AttributeNetwork)net;
            this.writer.write("\t\tid " + this.valueString(attrnet.getNodeAttribute("id").get(index).toString()));
            this.writer.newLine();
            int attributes = attrnet.getNodeAttributeCount();
            int i = 0;
            while (i < attributes) {
                Attribute attribute = attrnet.getNodeAttribute(i);
                String id = attribute.getID();
                if (!id.equals("id")) {
                    this.writer.write("\t\t" + id + " " + this.valueString(attribute.get(index)));
                    this.writer.newLine();
                }
                ++i;
            }
        } else {
            this.writer.write("\t\tid " + index);
            this.writer.newLine();
        }
        this.writer.write("\t]");
        this.writer.newLine();
    }

    private String valueString(Object value) throws IOException {
        if (value != null) {
            String str = value.toString();
            if (str.contains("\"")) {
                return "'" + str + "'";
            }
            if (this.shouldBeQuoted(str)) {
                return "\"" + str + "\"";
            }
            return str;
        }
        return "\"\"";
    }

    private boolean shouldBeQuoted(String str) {
        if (str.length() == 0) {
            return true;
        }
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c != '.' && c != '+' && c != '-' && (c < '0' || c > '9')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void writeLinks(Network net) throws IOException {
        int i = 0;
        while (i < net.size()) {
            int[] outlinks = net.outLinks(i);
            if (outlinks != null) {
                int j = 0;
                while (j < outlinks.length) {
                    if (net.isDirected() || i <= outlinks[j]) {
                        this.writeLink(net, i, outlinks[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void writeLink(Network net, int source, int target) throws IOException {
        this.writer.write("\tedge [");
        this.writer.newLine();
        if (net instanceof AttributeNetwork) {
            AttributeNetwork attrnet = (AttributeNetwork)net;
            Attribute nodeID = attrnet.getNodeAttribute("id");
            this.writer.write("\t\tsource " + this.valueString(nodeID.get(source).toString()));
            this.writer.newLine();
            this.writer.write("\t\ttarget " + this.valueString(nodeID.get(target).toString()));
            this.writer.newLine();
            int attributes = attrnet.getLinkAttributeCount();
            int i = 0;
            while (i < attributes) {
                LinkAttribute attribute = attrnet.getLinkAttribute(i);
                this.writer.write("\t\t" + attribute.getID() + " " + this.valueString(attribute.get(source, target)));
                this.writer.newLine();
                ++i;
            }
        } else {
            this.writer.write("\t\tsource " + source);
            this.writer.newLine();
            this.writer.write("\t\ttarget " + target);
            this.writer.newLine();
        }
        this.writer.write("\t]");
        this.writer.newLine();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

