/*
 * Decompiled with CFR 0.152.
 */
package noesis.io;

import ikor.model.data.DataModel;
import ikor.model.data.IntegerModel;
import ikor.model.data.RealModel;
import ikor.model.data.TextModel;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.LinkAttribute;
import noesis.Network;
import noesis.io.AttributeNetworkReader;

public class GraphMLNetworkReader
extends AttributeNetworkReader {
    private InputStream input;
    AttributeNetwork net;
    int source = 0;
    int target = 0;
    int nodes;
    boolean inNode = false;
    boolean inEdge = false;
    String attribute = null;

    public GraphMLNetworkReader(InputStream stream) {
        this.input = new BufferedInputStream(stream);
        this.setType(AttributeNetwork.class);
    }

    public Network read() throws IOException {
        this.net = new AttributeNetwork();
        this.net.addNodeAttribute(new Attribute("id"));
        this.nodes = this.net.size();
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLStreamReader xmlStreamReader = inputFactory.createXMLStreamReader(this.input);
            while (xmlStreamReader.hasNext()) {
                int event = xmlStreamReader.next();
                switch (event) {
                    case 1: {
                        String element = xmlStreamReader.getLocalName();
                        if (element.equals("graph")) {
                            this.inNode = false;
                            this.inEdge = false;
                            this.attribute = null;
                            this.parseGraphElement(xmlStreamReader);
                            break;
                        }
                        if (element.equals("node")) {
                            this.inNode = true;
                            this.inEdge = false;
                            this.attribute = null;
                            this.parseNodeElement(xmlStreamReader);
                            break;
                        }
                        if (element.equals("edge")) {
                            this.inEdge = true;
                            this.inNode = false;
                            this.attribute = null;
                            this.parseEdgeElement(xmlStreamReader);
                            break;
                        }
                        if (element.equals("data")) {
                            this.parseDataElement(xmlStreamReader);
                            break;
                        }
                        if (!element.equals("key")) break;
                        this.parseAttribute(xmlStreamReader);
                        break;
                    }
                    case 4: {
                        this.parseAttributeValue(xmlStreamReader);
                        this.attribute = null;
                    }
                }
            }
        }
        catch (FactoryConfigurationError e) {
            System.err.println("FactoryConfigurationError" + e.getMessage());
        }
        catch (XMLStreamException e) {
            System.err.println("XMLStreamException" + e.getMessage());
        }
        return this.net;
    }

    private void parseAttribute(XMLStreamReader xmlStreamReader) {
        String id = null;
        String scope = null;
        String type = null;
        int i = 0;
        while (i < xmlStreamReader.getAttributeCount()) {
            String key = xmlStreamReader.getAttributeLocalName(i);
            String value = xmlStreamReader.getAttributeValue(i);
            if (key.equals("for")) {
                scope = value;
            } else if (key.equals("id")) {
                id = value;
            } else if (key.equals("attr.name")) {
                id = value;
            } else if (key.equals("attr.type")) {
                type = value;
            }
            ++i;
        }
        if (scope != null) {
            DataModel model = this.dataModel(type);
            if (scope.equals("node")) {
                this.net.addNodeAttribute(new Attribute(id, model));
            } else if (scope.equals("edge")) {
                this.net.addLinkAttribute(new LinkAttribute(this.net, id, model));
            }
        }
    }

    private DataModel dataModel(String dataType) {
        String type = dataType.toLowerCase();
        DataModel<Double> model = type.equals("double") || type.equals("float") ? new RealModel() : (type.equals("long") || type.equals("int") ? new IntegerModel() : new TextModel());
        return model;
    }

    private void parseAttributeValue(XMLStreamReader xmlStreamReader) {
        if (this.attribute != null) {
            String value = xmlStreamReader.getText();
            if (this.inNode) {
                this.setNodeAttribute(this.net, this.nodes - 1, this.attribute, value);
            } else if (this.inEdge) {
                this.setLinkAttribute(this.net, this.source, this.target, this.attribute, value);
            }
        }
    }

    private void parseDataElement(XMLStreamReader xmlStreamReader) {
        int i = 0;
        while (i < xmlStreamReader.getAttributeCount()) {
            String key = xmlStreamReader.getAttributeLocalName(i);
            if (key.equals("key")) {
                this.attribute = xmlStreamReader.getAttributeValue(i);
            }
            ++i;
        }
    }

    private void parseGraphElement(XMLStreamReader xmlStreamReader) {
        int i = 0;
        while (i < xmlStreamReader.getAttributeCount()) {
            String key = xmlStreamReader.getAttributeLocalName(i);
            String value = xmlStreamReader.getAttributeValue(i);
            if (key.equals("edgedefault")) {
                if (value.equals("undirected")) {
                    this.net.setDirected(false);
                }
            } else if (key.equals("id")) {
                this.net.setID(value);
            }
            ++i;
        }
    }

    private void parseNodeElement(XMLStreamReader xmlStreamReader) {
        ++this.nodes;
        this.net.add(this.nodes - 1);
        int i = 0;
        while (i < xmlStreamReader.getAttributeCount()) {
            String key = xmlStreamReader.getAttributeLocalName(i);
            if (key.equals("id")) {
                this.setNodeID(this.net, this.nodes - 1, xmlStreamReader.getAttributeValue(i));
            }
            ++i;
        }
    }

    private void parseEdgeElement(XMLStreamReader xmlStreamReader) {
        int i = 0;
        while (i < xmlStreamReader.getAttributeCount()) {
            String key = xmlStreamReader.getAttributeLocalName(i);
            String value = xmlStreamReader.getAttributeValue(i);
            if (key.equals("source")) {
                this.source = this.getNodeIndex(value);
            } else if (key.equals("target")) {
                this.target = this.getNodeIndex(value);
            }
            ++i;
        }
        this.addLink(this.net, this.source, this.target);
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

