/*
 * Decompiled with CFR 0.152.
 */
package noesis.io;

import ikor.model.data.IntegerModel;
import ikor.model.data.RealModel;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.LinkAttribute;
import noesis.Network;
import noesis.io.AttributeNetworkWriter;

public class GraphMLNetworkWriter
extends AttributeNetworkWriter {
    private BufferedWriter output;
    private XMLStreamWriter writer;

    public GraphMLNetworkWriter(Writer writer) {
        this.output = new BufferedWriter(writer);
    }

    @Override
    public void write(Network net) throws IOException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            this.writer = factory.createXMLStreamWriter(this.output);
            this.writer.writeStartDocument("ISO-8859-1", "1.0");
            this.writer.writeStartElement("graphml");
            this.writer.writeAttribute("xmlns", "http://graphml.graphdrawing.org/xmlns");
            this.writer.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.writer.writeAttribute("xsi:schemaLocation", "http://graphml.graphdrawing.org/xmlns\nhttp://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd");
            if (net instanceof AttributeNetwork) {
                this.writeAttributes((AttributeNetwork)net);
            }
            this.writer.writeStartElement("graph");
            if (net.getID() != null) {
                this.writer.writeAttribute("id", net.getID());
            }
            if (net.isDirected()) {
                this.writer.writeAttribute("edgedefault", "directed");
            } else {
                this.writer.writeAttribute("edgedefault", "undirected");
            }
            this.writeNodes(net);
            this.writeLinks(net);
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.writeEndDocument();
            this.writer.flush();
            this.writer.close();
        }
        catch (XMLStreamException error) {
            throw new IOException(error);
        }
    }

    public void writeAttributes(AttributeNetwork net) throws IOException, XMLStreamException {
        String id;
        Attribute attribute;
        int i = 0;
        while (i < net.getNodeAttributeCount()) {
            attribute = net.getNodeAttribute(i);
            id = attribute.getID();
            if (!id.equals("id")) {
                this.writer.writeStartElement("key");
                this.writer.writeAttribute("id", id);
                this.writer.writeAttribute("for", "node");
                this.writer.writeAttribute("attr.name", id);
                if (attribute.getModel() instanceof RealModel) {
                    this.writer.writeAttribute("attr.type", "double");
                } else if (attribute.getModel() instanceof IntegerModel) {
                    this.writer.writeAttribute("attr.type", "int");
                } else {
                    this.writer.writeAttribute("attr.type", "string");
                }
                this.writer.writeEndElement();
            }
            ++i;
        }
        i = 0;
        while (i < net.getLinkAttributeCount()) {
            attribute = net.getLinkAttribute(i);
            id = attribute.getID();
            this.writer.writeStartElement("key");
            this.writer.writeAttribute("id", id);
            this.writer.writeAttribute("for", "edge");
            this.writer.writeAttribute("attr.name", id);
            this.writer.writeAttribute("attr.type", "string");
            this.writer.writeEndElement();
            ++i;
        }
    }

    public void writeNodes(Network net) throws IOException, XMLStreamException {
        int i = 0;
        while (i < net.size()) {
            this.writeNode(net, i);
            ++i;
        }
    }

    public void writeNode(Network net, int index) throws IOException, XMLStreamException {
        this.writer.writeStartElement("node");
        if (net instanceof AttributeNetwork) {
            AttributeNetwork attrnet = (AttributeNetwork)net;
            this.writer.writeAttribute("id", attrnet.getNodeAttribute("id").get(index).toString());
            int attributes = attrnet.getNodeAttributeCount();
            int i = 0;
            while (i < attributes) {
                Attribute attribute = attrnet.getNodeAttribute(i);
                String id = attribute.getID();
                if (!id.equals("id")) {
                    this.writer.writeStartElement("data");
                    this.writer.writeAttribute("key", id);
                    String str = this.formatString(attribute.get(index));
                    this.writer.writeCharacters(str);
                    this.writer.writeEndElement();
                }
                ++i;
            }
        } else {
            this.writer.writeAttribute("id", "" + index);
        }
        this.writer.writeEndElement();
    }

    private String formatString(Object value) throws IOException {
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    public void writeLinks(Network net) throws IOException, XMLStreamException {
        int i = 0;
        while (i < net.size()) {
            int[] outlinks = net.outLinks(i);
            if (outlinks != null) {
                int j = 0;
                while (j < outlinks.length) {
                    if (net.isDirected() || i <= outlinks[j]) {
                        this.writeLink(net, i, outlinks[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void writeLink(Network net, int source, int target) throws IOException, XMLStreamException {
        this.writer.writeStartElement("edge");
        if (net instanceof AttributeNetwork) {
            AttributeNetwork attrnet = (AttributeNetwork)net;
            Attribute nodeID = attrnet.getNodeAttribute("id");
            this.writer.writeAttribute("source", nodeID.get(source).toString());
            this.writer.writeAttribute("target", nodeID.get(target).toString());
            int attributes = attrnet.getLinkAttributeCount();
            int i = 0;
            while (i < attributes) {
                LinkAttribute attribute = attrnet.getLinkAttribute(i);
                String id = attribute.getID();
                if (!id.equals("id")) {
                    this.writer.writeStartElement("data");
                    this.writer.writeAttribute("key", id);
                    this.writer.writeCharacters(this.formatString(attribute.get(source, target)));
                    this.writer.writeEndElement();
                }
                ++i;
            }
        } else {
            this.writer.writeAttribute("source", "" + source);
            this.writer.writeAttribute("target", "" + target);
        }
        this.writer.writeEndElement();
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }
}

