/*
 * Decompiled with CFR 0.152.
 */
package noesis.io;

import ikor.math.Decimal;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.LinkAttribute;
import noesis.Network;
import noesis.io.AttributeNetworkReader;

public class PajekNetworkReader
extends AttributeNetworkReader {
    private BufferedReader input;
    private String currentLine;
    private final int startIndex = 1;
    private int bimode = 0;

    public PajekNetworkReader(Reader reader) {
        this.input = new BufferedReader(reader);
        this.currentLine = null;
        this.setType(AttributeNetwork.class);
    }

    private String readLine() throws IOException {
        String line;
        do {
            if ((line = this.input.readLine()) == null) continue;
            line = line.trim();
        } while (line != null && (line.length() == 0 || line.startsWith("%")));
        this.currentLine = line;
        return line;
    }

    private String currentLine() {
        return this.currentLine;
    }

    private void readNetwork(AttributeNetwork net) throws IOException {
        net.setID(this.currentLine().substring(this.currentLine.indexOf(32)).trim());
        this.readLine();
    }

    private void readVertices(AttributeNetwork net) throws IOException {
        String line = this.currentLine();
        StringTokenizer tokenizer = new StringTokenizer(line);
        tokenizer.nextToken();
        int vertices = Integer.parseInt(tokenizer.nextToken());
        if (tokenizer.hasMoreTokens()) {
            this.bimode = Integer.parseInt(tokenizer.nextToken());
        }
        net.setSize(vertices);
        int i = 1;
        while (i <= vertices) {
            this.setNodeID(net, i - 1, "" + i);
            ++i;
        }
        line = this.readLine();
        while (line != null && !line.startsWith("*")) {
            int start = line.indexOf(34);
            if (start != -1) {
                int end = line.indexOf(34, start + 1);
                String label = line.substring(start + 1, end);
                int node = Integer.parseInt(line.substring(0, start - 1)) - 1;
                this.setNodeID(net, node, label);
            }
            line = this.readLine();
        }
    }

    private void readArcList(AttributeNetwork net) throws IOException {
        String line = this.readLine();
        while (line != null && !line.startsWith("*")) {
            StringTokenizer tokenizer = new StringTokenizer(line);
            int source = Integer.parseInt(tokenizer.nextToken());
            while (tokenizer.hasMoreTokens()) {
                int destination = Integer.parseInt(tokenizer.nextToken());
                net.add(source - 1, destination - 1);
            }
            line = this.readLine();
        }
    }

    private void readEdgeList(AttributeNetwork net) throws IOException {
        String line = this.readLine();
        while (line != null && !line.startsWith("*")) {
            StringTokenizer tokenizer = new StringTokenizer(line);
            int source = Integer.parseInt(tokenizer.nextToken());
            while (tokenizer.hasMoreTokens()) {
                int destination = Integer.parseInt(tokenizer.nextToken());
                net.add(source - 1, destination - 1);
                net.add(destination - 1, source - 1);
            }
            line = this.readLine();
        }
    }

    private void readArcPairs(AttributeNetwork net) throws IOException {
        Decimal one = new Decimal(1.0);
        String line = this.readLine();
        while (line != null && !line.startsWith("*")) {
            StringTokenizer tokenizer = new StringTokenizer(line);
            int source = Integer.parseInt(tokenizer.nextToken());
            int destination = Integer.parseInt(tokenizer.nextToken());
            Decimal value = tokenizer.hasMoreTokens() ? new Decimal(tokenizer.nextToken()) : one;
            net.add(source - 1, destination - 1);
            net.getLinkAttribute("value").set(source - 1, destination - 1, value);
            line = this.readLine();
        }
    }

    private void readEdgePairs(AttributeNetwork net) throws IOException {
        Decimal one = new Decimal(1.0);
        String line = this.readLine();
        while (line != null && !line.startsWith("*")) {
            StringTokenizer tokenizer = new StringTokenizer(line);
            int source = Integer.parseInt(tokenizer.nextToken());
            int destination = Integer.parseInt(tokenizer.nextToken());
            Decimal value = tokenizer.hasMoreTokens() ? new Decimal(tokenizer.nextToken()) : one;
            net.add(source - 1, destination - 1);
            net.add(destination - 1, source - 1);
            net.getLinkAttribute("value").set(source - 1, destination - 1, value);
            net.getLinkAttribute("value").set(destination - 1, source - 1, value);
            line = this.readLine();
        }
    }

    private void readMatrix(AttributeNetwork net) throws IOException {
        if (this.bimode == 0) {
            int i = 0;
            while (i < net.size()) {
                String line = this.readLine();
                StringTokenizer tokenizer = new StringTokenizer(line);
                int j = 0;
                while (j < net.size()) {
                    Decimal value = new Decimal(tokenizer.nextToken());
                    if (value.intValue() > 0) {
                        net.add(i, j);
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.bimode) {
                String line = this.readLine();
                StringTokenizer tokenizer = new StringTokenizer(line);
                int j = 0;
                while (j < net.size() - this.bimode) {
                    Decimal value = new Decimal(tokenizer.nextToken());
                    if (value.intValue() > 0) {
                        net.add(i, this.bimode + j);
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.readLine();
    }

    public Network read() throws IOException {
        AttributeNetwork net = new AttributeNetwork();
        net.addNodeAttribute(new Attribute("id"));
        net.addLinkAttribute(new LinkAttribute(net, "value"));
        this.readLine();
        while (this.currentLine() != null && this.currentLine().startsWith("*")) {
            String line = this.currentLine().toLowerCase();
            if (line.startsWith("*net")) {
                this.readNetwork(net);
                continue;
            }
            if (line.startsWith("*vertices")) {
                this.readVertices(net);
                continue;
            }
            if (line.startsWith("*arcslist")) {
                this.readArcList(net);
                continue;
            }
            if (line.startsWith("*edgeslist")) {
                this.readEdgeList(net);
                continue;
            }
            if (line.startsWith("*arcs")) {
                this.readArcPairs(net);
                continue;
            }
            if (line.startsWith("*edges")) {
                this.readEdgePairs(net);
                continue;
            }
            if (line.startsWith("*matrix")) {
                this.readMatrix(net);
                continue;
            }
            throw new IOException("Unsupported Pajek file format");
        }
        return net;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

