/*
 * Decompiled with CFR 0.152.
 */
package noesis.io;

import ikor.math.Decimal;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.LinkAttribute;
import noesis.Network;
import noesis.io.AttributeNetworkWriter;

public class PajekNetworkWriter
extends AttributeNetworkWriter {
    private BufferedWriter writer;
    private static final Decimal one = new Decimal(1.0);

    public PajekNetworkWriter(Writer writer) {
        this.writer = new BufferedWriter(writer);
    }

    @Override
    public void write(Network net) throws IOException {
        this.writeNodes((AttributeNetwork)net);
        this.writeLinks((AttributeNetwork)net);
        this.writer.flush();
    }

    public void writeNodes(AttributeNetwork net) throws IOException {
        Attribute id = net.getNodeAttribute("id");
        this.writer.write("*vertices " + net.size());
        this.writer.newLine();
        int i = 0;
        while (i < net.size()) {
            this.writer.write("" + (i + 1));
            if (id.get(i) != null && !id.get(i).equals("" + (i + 1))) {
                this.writer.write(" \"" + id.get(i) + "\"");
            }
            this.writer.newLine();
            ++i;
        }
    }

    public void writeLinks(AttributeNetwork net) throws IOException {
        Decimal symmetric;
        Decimal value;
        int j;
        this.writer.write("*arcs");
        this.writer.newLine();
        int i = 0;
        while (i < net.size()) {
            j = 0;
            while (j < net.size()) {
                if (net.get(i, j) != null) {
                    value = this.getValue(net, i, j);
                    if (net.get(j, i) == null) {
                        this.writeArc(i, j, value);
                    } else {
                        symmetric = this.getValue(net, j, i);
                        if (!value.equals(symmetric)) {
                            this.writeArc(i, j, value);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        this.writer.write("*edges");
        this.writer.newLine();
        i = 0;
        while (i < net.size()) {
            j = i + 1;
            while (j < net.size()) {
                if (net.get(i, j) != null) {
                    value = this.getValue(net, i, j);
                    if (net.get(j, i) != null && value.equals(symmetric = this.getValue(net, j, i))) {
                        this.writeArc(i, j, value);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void writeArc(int i, int j, Decimal value) throws IOException {
        this.writer.write(i + 1 + " " + (j + 1));
        if (value != null) {
            this.writer.write(" " + value.toString());
        }
        this.writer.newLine();
    }

    private Decimal getValue(AttributeNetwork net, int i, int j) {
        LinkAttribute attribute = net.getLinkAttribute("value");
        Decimal value = (Decimal)attribute.get(i, j);
        if (value != null) {
            return value;
        }
        return one;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

