/*
 * Decompiled with CFR 0.152.
 */
package noesis.io;

import ikor.math.Decimal;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;
import noesis.Network;
import noesis.io.NetworkReader;

public class SNAPNetworkReader
extends NetworkReader<String, Decimal> {
    private BufferedReader input;

    public SNAPNetworkReader() {
        this.input = null;
    }

    public SNAPNetworkReader(Reader reader) {
        this.setReader(reader);
    }

    public void setReader(Reader reader) {
        this.input = new BufferedReader(reader);
    }

    private String readLine() throws IOException {
        String line;
        while ((line = this.input.readLine()) != null && line.trim().length() == 0) {
        }
        return line;
    }

    @Override
    public Network<String, Decimal> read() throws IOException {
        Network<String, Decimal> net = this.createNetwork();
        this.readLine();
        net.setID(this.readLine().substring(2));
        String line = this.readLine();
        StringTokenizer tokenizer = new StringTokenizer(line);
        String token = tokenizer.nextToken();
        assert (token.equals("#"));
        token = tokenizer.nextToken();
        assert (token.equals("Nodes:"));
        int nodes = Integer.parseInt(tokenizer.nextToken());
        net.setSize(nodes);
        this.readLine();
        line = this.readLine();
        while (line != null) {
            int destination;
            int mark = line.indexOf(9);
            String idSource = line.substring(0, mark);
            String idDestination = line.substring(mark + 1);
            int source = net.index(idSource);
            if (source == -1) {
                source = net.add(idSource);
            }
            if ((destination = net.index(idDestination)) == -1) {
                destination = net.add(idDestination);
            }
            if (!net.add(source, destination)) {
                System.err.println(line);
            }
            line = this.readLine();
        }
        return net;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

