/*
 * Decompiled with CFR 0.152.
 */
package noesis.io.graphics;

import ikor.model.graphics.Line;
import ikor.model.graphics.Style;
import ikor.model.graphics.colors.ColorMap;
import ikor.util.indexer.Indexer;
import java.awt.Color;
import noesis.io.graphics.LinkRenderer;
import noesis.io.graphics.NetworkRenderer;

public class ColorMapLinkRenderer
extends LinkRenderer {
    public static final int DEFAULT_COLORS = 16;
    public static final Color DEFAULT_COLOR = new Color(112, 112, 112, 255);
    private Style[][] cache;

    @Override
    public void setColorMap(ColorMap colorMap) {
        super.setColorMap(colorMap);
        this.cache = null;
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        this.cache = null;
    }

    @Override
    public void setWidthIndexer(Indexer<Long> widthIndex) {
        super.setWidthIndexer(widthIndex);
        this.cache = null;
    }

    @Override
    public Style getStyle(int source, int target) {
        int width;
        int widthIndex;
        Color color;
        int colorIndex;
        if (this.cache == null) {
            int colorMapSize = 1;
            if (this.getColorIndexer() != null) {
                colorMapSize = this.getColorMap().size();
            }
            int widthSize = 1;
            if (this.getWidthIndexer() != null) {
                widthSize = this.getWidthIndexer().range() + 1;
            }
            this.cache = new Style[colorMapSize][widthSize];
        }
        if (this.getColorIndexer() == null) {
            colorIndex = 0;
            color = DEFAULT_COLOR;
        } else {
            colorIndex = this.getColorIndex(source, target);
            color = this.getColor(source, target);
        }
        if (this.getWidthIndexer() == null) {
            widthIndex = 0;
            width = 1 + this.getWidth();
        } else {
            widthIndex = this.getWidthIndex(source, target);
            width = this.getWidth(source, target);
        }
        if (this.cache[colorIndex][widthIndex] == null) {
            this.cache[colorIndex][widthIndex] = new Style(color, width);
        }
        return this.cache[colorIndex][widthIndex];
    }

    @Override
    public void render(NetworkRenderer drawing, int source, int target) {
        drawing.add(new Line(drawing.getLinkId(source, target), this.getStyle(source, target), drawing.getX(source), drawing.getY(source), drawing.getX(target), drawing.getY(target)));
    }

    @Override
    public void update(NetworkRenderer drawing, int source, int target) {
        Line link = (Line)drawing.getDrawingElement(drawing.getLinkId(source, target));
        if (link != null) {
            link.setStartX(drawing.getX(source));
            link.setStartY(drawing.getY(source));
            link.setEndX(drawing.getX(target));
            link.setEndY(drawing.getY(target));
            link.setStyle(this.getStyle(source, target));
        }
    }
}

