/*
 * Decompiled with CFR 0.152.
 */
package noesis.io.graphics;

import ikor.model.graphics.Circle;
import ikor.model.graphics.Style;
import ikor.model.graphics.colors.ColorMap;
import ikor.model.graphics.colors.JetColorMap;
import ikor.util.indexer.CyclicIndexer;
import ikor.util.indexer.Indexer;
import java.awt.Color;
import noesis.io.graphics.NetworkRenderer;
import noesis.io.graphics.NodeRenderer;

public class ColorMapNodeRenderer
extends NodeRenderer {
    public static final int DEFAULT_COLORS = 16;
    public static final ColorMap DEFAULT_COLOR_MAP = new JetColorMap(16);
    public static final Indexer<Integer> DEFAULT_COLOR_INDEXER = new CyclicIndexer(16);
    public static final Style DEFAULT_BORDER = new Style(new Color(0, 0, 0, 255), 2);
    Style[] cache;

    public ColorMapNodeRenderer() {
        this.setColorMap(DEFAULT_COLOR_MAP);
        this.setColorIndexer(DEFAULT_COLOR_INDEXER);
    }

    public ColorMapNodeRenderer(ColorMap colors) {
        this.setColorMap(colors);
        this.setColorIndexer(DEFAULT_COLOR_INDEXER);
    }

    @Override
    public void setColorMap(ColorMap colorMap) {
        if (colorMap != null) {
            super.setColorMap(colorMap);
        } else {
            super.setColorMap(DEFAULT_COLOR_MAP);
        }
        this.cache = null;
    }

    @Override
    public Style getStyle(int node) {
        int index = this.getColorIndex(node);
        if (this.cache == null) {
            this.cache = new Style[this.getColorMap().size()];
        }
        if (this.cache[index] == null) {
            this.cache[index] = new Style(this.getColorMap().getColor(index), 2);
        }
        return this.cache[index];
    }

    @Override
    public void render(NetworkRenderer drawing, int node) {
        int x = drawing.getX(node);
        int y = drawing.getY(node);
        drawing.add(new Circle(drawing.getNodeId(node), this.getStyle(node), DEFAULT_BORDER, x, y, this.getSize(node)));
    }

    @Override
    public void update(NetworkRenderer drawing, int node) {
        int x = drawing.getX(node);
        int y = drawing.getY(node);
        Circle circle = (Circle)drawing.getDrawingElement(drawing.getNodeId(node));
        if (circle != null) {
            circle.setCenterX(x);
            circle.setCenterY(y);
            circle.setRadius(this.getSize(node));
            circle.setStyle(this.getStyle(node));
        }
    }
}

