/*
 * Decompiled with CFR 0.152.
 */
package noesis.io.graphics;

import ikor.model.graphics.Circle;
import ikor.model.graphics.Style;
import java.awt.Color;
import noesis.io.graphics.NetworkRenderer;
import noesis.io.graphics.NodeRenderer;

public class ColorNodeRenderer
extends NodeRenderer {
    public static final Style[] DEFAULT_COLORS = new Style[]{new Style(new Color(176, 0, 0, 255), 2), new Style(new Color(0, 176, 0, 255), 2), new Style(new Color(0, 0, 176, 255), 2)};
    public static final Style[] DEFAULT_BORDERS = new Style[]{new Style(new Color(51, 0, 0, 255), 2), new Style(new Color(0, 51, 0, 255), 2), new Style(new Color(0, 0, 51, 255), 2)};
    private Style[] colors;
    private Style[] borders;

    public ColorNodeRenderer() {
        this.colors = DEFAULT_COLORS;
        this.borders = DEFAULT_BORDERS;
    }

    public ColorNodeRenderer(Style[] colors, Style[] borders) {
        this.colors = colors;
        this.borders = borders;
    }

    @Override
    public Style getStyle(int node) {
        int pos = node % this.colors.length;
        if (this.getColorIndexer() != null) {
            pos = (int)Math.round((double)(this.colors.length - 1) * ((double)this.getColorIndex(node) / (double)this.getColorIndexer().max()));
        }
        return this.colors[pos];
    }

    public Style getBorder(int node) {
        return this.borders[node % this.borders.length];
    }

    @Override
    public void render(NetworkRenderer drawing, int node) {
        int x = drawing.getX(node);
        int y = drawing.getY(node);
        drawing.add(new Circle(drawing.getNodeId(node), this.getStyle(node), this.getBorder(node), x, y, this.getSize(node)));
    }

    @Override
    public void update(NetworkRenderer drawing, int node) {
        int x = drawing.getX(node);
        int y = drawing.getY(node);
        Circle circle = (Circle)drawing.getDrawingElement(drawing.getNodeId(node));
        if (circle != null) {
            circle.setCenterX(x);
            circle.setCenterY(y);
            circle.setRadius(this.getSize(node));
            circle.setStyle(this.getStyle(node));
            circle.setBorder(this.getBorder(node));
        }
    }
}

