/*
 * Decompiled with CFR 0.152.
 */
package noesis.io.graphics;

import ikor.model.graphics.Line;
import ikor.model.graphics.Style;
import java.awt.Color;
import noesis.io.graphics.LinkRenderer;
import noesis.io.graphics.NetworkRenderer;

public class DefaultLinkRenderer
extends LinkRenderer {
    public static final Color DEFAULT_COLOR = new Color(112, 112, 112, 255);
    private Style style;

    public DefaultLinkRenderer() {
        this.style = new Style(DEFAULT_COLOR, 1);
    }

    public DefaultLinkRenderer(Style style) {
        this.style = style;
    }

    @Override
    public void setWidth(int width) {
        if (width >= 0) {
            super.setWidth(width);
            this.style.setWidth(width);
        }
    }

    @Override
    public void render(NetworkRenderer drawing, int source, int target) {
        drawing.add(new Line(drawing.getLinkId(source, target), this.style, drawing.getX(source), drawing.getY(source), drawing.getX(target), drawing.getY(target)));
    }

    @Override
    public void update(NetworkRenderer drawing, int source, int target) {
        Line link = (Line)drawing.getDrawingElement(drawing.getLinkId(source, target));
        if (link != null) {
            link.setStartX(drawing.getX(source));
            link.setStartY(drawing.getY(source));
            link.setEndX(drawing.getX(target));
            link.setEndY(drawing.getY(target));
        }
    }

    @Override
    public Style getStyle(int source, int target) {
        return this.style;
    }
}

