/*
 * Decompiled with CFR 0.152.
 */
package noesis.io.graphics;

import ikor.model.graphics.Line;
import ikor.model.graphics.Style;
import ikor.model.ui.DatasetSelection;
import ikor.util.indexer.Indexer;
import java.awt.Color;
import noesis.io.graphics.LinkSelectionRenderer;
import noesis.io.graphics.NetworkRenderer;

public class DefaultLinkSelectionRenderer
extends LinkSelectionRenderer {
    public static final Style DEFAULT_NON_SELECTED_STYLE = new Style(new Color(0, 0, 0, 0));
    public static final Color DEFAULT_SELECTED_COLOR = new Color(176, 0, 0, 255);
    public static final int DEFAULT_SELECTED_WIDTH = 5;
    private Indexer<Long> lastUsedIndexer;
    private int lastUsedWidth;
    private Style[] cache;

    public DefaultLinkSelectionRenderer(NetworkRenderer networkRenderer, DatasetSelection linkSelection) {
        super(networkRenderer, linkSelection);
        this.lastUsedIndexer = networkRenderer.getLinkRenderer().getWidthIndexer();
        this.lastUsedWidth = networkRenderer.getLinkRenderer().getWidth();
    }

    @Override
    public void render(NetworkRenderer drawing, int source, int target) {
        drawing.add(new Line(this.getLinkSelectionID(drawing.getLinkId(source, target)), this.getStyle(source, target), drawing.getX(source), drawing.getY(source), drawing.getX(target), drawing.getY(target)));
    }

    @Override
    public void update(NetworkRenderer drawing, int source, int target) {
        Line link = (Line)drawing.getDrawingElement(this.getLinkSelectionID(drawing.getLinkId(source, target)));
        if (link != null) {
            link.setStartX(drawing.getX(source));
            link.setStartY(drawing.getY(source));
            link.setEndX(drawing.getX(target));
            link.setEndY(drawing.getY(target));
            link.setStyle(this.getStyle(source, target));
        }
    }

    @Override
    public Style getStyle(int source, int target) {
        Indexer<Long> currentIndexer = this.networkRenderer.getLinkRenderer().getWidthIndexer();
        int currentWidth = this.networkRenderer.getLinkRenderer().getWidth();
        if (this.cache == null || currentIndexer != this.lastUsedIndexer || currentWidth != this.lastUsedWidth) {
            this.cache = new Style[currentIndexer == null ? 1 : currentIndexer.range() + 1];
            this.lastUsedIndexer = currentIndexer;
            this.lastUsedWidth = currentWidth;
        }
        int linkIndex = this.networkRenderer.getNetwork().index(source, target);
        int width = this.networkRenderer.getLinkRenderer().getWidth(source, target);
        if (this.linkSelection.contains(linkIndex)) {
            int cacheIndex;
            int n = cacheIndex = currentIndexer == null ? 0 : currentIndexer.index(Long.valueOf(width));
            if (this.cache[cacheIndex] == null) {
                this.cache[cacheIndex] = new Style(DEFAULT_SELECTED_COLOR, width + 5);
            }
            return this.cache[cacheIndex];
        }
        return DEFAULT_NON_SELECTED_STYLE;
    }
}

