/*
 * Decompiled with CFR 0.152.
 */
package noesis.io.graphics;

import ikor.model.graphics.Circle;
import ikor.model.graphics.Style;
import java.awt.Color;
import noesis.io.graphics.NetworkRenderer;
import noesis.io.graphics.NodeRenderer;

public class DefaultNodeRenderer
extends NodeRenderer {
    public static final Style DEFAULT_NODE_STYLE = new Style(new Color(192, 192, 192, 255), 2);
    public static final Style DEFAULT_BORDER_STYLE = new Style(new Color(0, 0, 0, 255), 2);

    @Override
    public Style getStyle(int node) {
        return DEFAULT_NODE_STYLE;
    }

    @Override
    public void render(NetworkRenderer drawing, int node) {
        int x = drawing.getX(node);
        int y = drawing.getY(node);
        drawing.add(new Circle(drawing.getNodeId(node), this.getStyle(node), DEFAULT_BORDER_STYLE, x, y, this.getSize(node)));
    }

    @Override
    public void update(NetworkRenderer drawing, int node) {
        int x = drawing.getX(node);
        int y = drawing.getY(node);
        Circle circle = (Circle)drawing.getDrawingElement(drawing.getNodeId(node));
        if (circle != null) {
            circle.setCenterX(x);
            circle.setCenterY(y);
            circle.setRadius(this.getSize(node));
            circle.setStyle(this.getStyle(node));
        }
    }
}

