/*
 * Decompiled with CFR 0.152.
 */
package noesis.io.graphics;

import ikor.model.graphics.Circle;
import ikor.model.graphics.Style;
import ikor.model.ui.DatasetSelection;
import java.awt.Color;
import noesis.io.graphics.NetworkRenderer;
import noesis.io.graphics.NodeSelectionRenderer;

public class DefaultNodeSelectionRenderer
extends NodeSelectionRenderer {
    public static final Style DEFAULT_BODY_STYLE = new Style(new Color(0, 0, 0, 0));
    public static final Style DEFAULT_NON_SELECTED_BORDER_STYLE = new Style(new Color(0, 0, 0, 0), 0);
    public static final Style DEFAULT_SELECTED_BORDER_STYLE = new Style(new Color(176, 0, 0, 255), 3);

    public DefaultNodeSelectionRenderer(NetworkRenderer networkRenderer, DatasetSelection nodeSelection) {
        super(networkRenderer, nodeSelection);
    }

    @Override
    public void render(NetworkRenderer drawing, int node) {
        int x = drawing.getX(node);
        int y = drawing.getY(node);
        Style borderStyle = this.getStyle(node);
        Circle selectionCircle = new Circle(this.getNodeSelectionID(drawing.getNodeId(node)), DEFAULT_BODY_STYLE, borderStyle, x, y, this.networkRenderer.getNodeRenderer().getSize(node));
        drawing.add(selectionCircle);
    }

    @Override
    public void update(NetworkRenderer drawing, int node) {
        int x = drawing.getX(node);
        int y = drawing.getY(node);
        Circle circle = (Circle)drawing.getDrawingElement(this.getNodeSelectionID(drawing.getNodeId(node)));
        if (circle != null) {
            Style borderStyle = this.getStyle(node);
            circle.setCenterX(x);
            circle.setCenterY(y);
            circle.setRadius(this.networkRenderer.getNodeRenderer().getSize(node));
            circle.setStyle(DEFAULT_BODY_STYLE);
            circle.setBorder(borderStyle);
        }
    }

    @Override
    public Style getStyle(int node) {
        Style borderStyle = this.nodeSelection.contains(node) ? DEFAULT_SELECTED_BORDER_STYLE : DEFAULT_NON_SELECTED_BORDER_STYLE;
        return borderStyle;
    }
}

