/*
 * Decompiled with CFR 0.152.
 */
package noesis.io.graphics;

import ikor.model.graphics.Circle;
import ikor.model.graphics.Style;
import ikor.model.graphics.colors.ColorMap;
import ikor.model.graphics.styles.Gradient;
import ikor.model.graphics.styles.GradientKeyframe;
import ikor.model.graphics.styles.LinearGradient;
import ikor.model.graphics.styles.RadialGradient;
import java.awt.Color;
import noesis.io.graphics.NetworkRenderer;
import noesis.io.graphics.NodeRenderer;

public class GradientNodeRenderer
extends NodeRenderer {
    public static final int DEFAULT_BORDER = 0;
    private boolean radial;
    private Gradient gradient;
    private Style border;
    Style[] cache;

    public GradientNodeRenderer(boolean radial) {
        this.radial = radial;
        this.gradient = this.createGradient(new Color(0, 0, 176, 255));
        this.border = new Style(new Color(0, 0, 0, 255), 0);
    }

    public GradientNodeRenderer(Gradient gradient, Style border) {
        this.gradient = gradient;
        this.border = border;
    }

    @Override
    public void setColorMap(ColorMap colorMap) {
        super.setColorMap(colorMap);
        this.cache = null;
    }

    private Gradient createGradient(Color color) {
        Gradient gradient = this.radial ? new RadialGradient(0.3f, 0.3f, 0.5f) : new LinearGradient(0.4f, 0.4f, 0.8f, 0.8f);
        gradient.addKeyframe(new GradientKeyframe(0.0f, new Color(240, 240, 240, 255)));
        gradient.addKeyframe(new GradientKeyframe(1.0f, color));
        gradient.setWidth(10);
        return gradient;
    }

    @Override
    public Style getStyle(int node) {
        if (this.getColorIndexer() != null) {
            int index = this.getColorIndex(node);
            if (this.cache == null) {
                this.cache = new Style[this.getColorMap().size()];
            }
            if (this.cache[index] == null) {
                this.cache[index] = this.createGradient(this.getColor(node));
            }
            return this.cache[index];
        }
        return this.gradient;
    }

    @Override
    public void render(NetworkRenderer drawing, int node) {
        int x = drawing.getX(node);
        int y = drawing.getY(node);
        if (this.getSize(node) > 0) {
            drawing.add(new Circle(drawing.getNodeId(node), this.getStyle(node), this.border, x, y, this.getSize(node)));
        }
    }

    @Override
    public void update(NetworkRenderer drawing, int node) {
        int x = drawing.getX(node);
        int y = drawing.getY(node);
        Circle circle = (Circle)drawing.getDrawingElement(drawing.getNodeId(node));
        if (circle != null) {
            circle.setCenterX(x);
            circle.setCenterY(y);
            circle.setRadius(this.getSize(node));
            circle.setStyle(this.getStyle(node));
        }
    }
}

